/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class SPacketCustomSound
implements Packet<INetHandlerPlayClient> {
    private String soundName;
    private SoundCategory category;
    private int x;
    private int y = Integer.MAX_VALUE;
    private int z;
    private float volume;
    private float pitch;

    public SPacketCustomSound() {
    }

    public SPacketCustomSound(String p_i46948_1_, SoundCategory p_i46948_2_, double p_i46948_3_, double p_i46948_5_, double p_i46948_7_, float p_i46948_9_, float p_i46948_10_) {
        Validate.notNull((Object)p_i46948_1_, (String)"name", (Object[])new Object[0]);
        this.soundName = p_i46948_1_;
        this.category = p_i46948_2_;
        this.x = (int)(p_i46948_3_ * 8.0);
        this.y = (int)(p_i46948_5_ * 8.0);
        this.z = (int)(p_i46948_7_ * 8.0);
        this.volume = p_i46948_9_;
        this.pitch = p_i46948_10_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.soundName = p_readPacketData_1_.readString(256);
        this.category = p_readPacketData_1_.readEnumValue(SoundCategory.class);
        this.x = p_readPacketData_1_.readInt();
        this.y = p_readPacketData_1_.readInt();
        this.z = p_readPacketData_1_.readInt();
        this.volume = p_readPacketData_1_.readFloat();
        this.pitch = p_readPacketData_1_.readFloat();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.soundName);
        p_writePacketData_1_.writeEnumValue(this.category);
        p_writePacketData_1_.writeInt(this.x);
        p_writePacketData_1_.writeInt(this.y);
        p_writePacketData_1_.writeInt(this.z);
        p_writePacketData_1_.writeFloat(this.volume);
        p_writePacketData_1_.writeFloat(this.pitch);
    }

    @SideOnly(value=Side.CLIENT)
    public String getSoundName() {
        return this.soundName;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleCustomSound(this);
    }

    @SideOnly(value=Side.CLIENT)
    public SoundCategory getCategory() {
        return this.category;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return (float)this.x / 8.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return (float)this.y / 8.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return (float)this.z / 8.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return this.volume;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPitch() {
        return this.pitch;
    }
}

