/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntity
implements Packet<INetHandlerPlayClient> {
    protected int entityId;
    protected int posX;
    protected int posY;
    protected int posZ;
    protected byte yaw;
    protected byte pitch;
    protected boolean onGround;
    protected boolean rotating;

    public SPacketEntity() {
    }

    public SPacketEntity(int p_i46936_1_) {
        this.entityId = p_i46936_1_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleEntityMovement(this);
    }

    public String toString() {
        return "Entity_" + super.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getEntity(World p_getEntity_1_) {
        return p_getEntity_1_.getEntityByID(this.entityId);
    }

    @SideOnly(value=Side.CLIENT)
    public int getX() {
        return this.posX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getY() {
        return this.posY;
    }

    @SideOnly(value=Side.CLIENT)
    public int getZ() {
        return this.posZ;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRotating() {
        return this.rotating;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getOnGround() {
        return this.onGround;
    }

    public static class S16PacketEntityLook
    extends SPacketEntity {
        public S16PacketEntityLook() {
            this.rotating = true;
        }

        public S16PacketEntityLook(int p_i47081_1_, byte p_i47081_2_, byte p_i47081_3_, boolean p_i47081_4_) {
            super(p_i47081_1_);
            this.yaw = p_i47081_2_;
            this.pitch = p_i47081_3_;
            this.rotating = true;
            this.onGround = p_i47081_4_;
        }

        @Override
        public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
            super.readPacketData(p_readPacketData_1_);
            this.yaw = p_readPacketData_1_.readByte();
            this.pitch = p_readPacketData_1_.readByte();
            this.onGround = p_readPacketData_1_.readBoolean();
        }

        @Override
        public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
            super.writePacketData(p_writePacketData_1_);
            p_writePacketData_1_.writeByte(this.yaw);
            p_writePacketData_1_.writeByte(this.pitch);
            p_writePacketData_1_.writeBoolean(this.onGround);
        }
    }

    public static class S15PacketEntityRelMove
    extends SPacketEntity {
        public S15PacketEntityRelMove() {
        }

        public S15PacketEntityRelMove(int p_i47083_1_, long p_i47083_2_, long p_i47083_4_, long p_i47083_6_, boolean p_i47083_8_) {
            super(p_i47083_1_);
            this.posX = (int)p_i47083_2_;
            this.posY = (int)p_i47083_4_;
            this.posZ = (int)p_i47083_6_;
            this.onGround = p_i47083_8_;
        }

        @Override
        public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
            super.readPacketData(p_readPacketData_1_);
            this.posX = p_readPacketData_1_.readShort();
            this.posY = p_readPacketData_1_.readShort();
            this.posZ = p_readPacketData_1_.readShort();
            this.onGround = p_readPacketData_1_.readBoolean();
        }

        @Override
        public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
            super.writePacketData(p_writePacketData_1_);
            p_writePacketData_1_.writeShort(this.posX);
            p_writePacketData_1_.writeShort(this.posY);
            p_writePacketData_1_.writeShort(this.posZ);
            p_writePacketData_1_.writeBoolean(this.onGround);
        }
    }

    public static class S17PacketEntityLookMove
    extends SPacketEntity {
        public S17PacketEntityLookMove() {
            this.rotating = true;
        }

        public S17PacketEntityLookMove(int p_i47082_1_, long p_i47082_2_, long p_i47082_4_, long p_i47082_6_, byte p_i47082_8_, byte p_i47082_9_, boolean p_i47082_10_) {
            super(p_i47082_1_);
            this.posX = (int)p_i47082_2_;
            this.posY = (int)p_i47082_4_;
            this.posZ = (int)p_i47082_6_;
            this.yaw = p_i47082_8_;
            this.pitch = p_i47082_9_;
            this.onGround = p_i47082_10_;
            this.rotating = true;
        }

        @Override
        public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
            super.readPacketData(p_readPacketData_1_);
            this.posX = p_readPacketData_1_.readShort();
            this.posY = p_readPacketData_1_.readShort();
            this.posZ = p_readPacketData_1_.readShort();
            this.yaw = p_readPacketData_1_.readByte();
            this.pitch = p_readPacketData_1_.readByte();
            this.onGround = p_readPacketData_1_.readBoolean();
        }

        @Override
        public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
            super.writePacketData(p_writePacketData_1_);
            p_writePacketData_1_.writeShort(this.posX);
            p_writePacketData_1_.writeShort(this.posY);
            p_writePacketData_1_.writeShort(this.posZ);
            p_writePacketData_1_.writeByte(this.yaw);
            p_writePacketData_1_.writeByte(this.pitch);
            p_writePacketData_1_.writeBoolean(this.onGround);
        }
    }
}

