/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityEffect
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private byte effectId;
    private byte amplifier;
    private int duration;
    private byte flags;

    public SPacketEntityEffect() {
    }

    public SPacketEntityEffect(int p_i46891_1_, PotionEffect p_i46891_2_) {
        this.entityId = p_i46891_1_;
        this.effectId = (byte)(Potion.getIdFromPotion(p_i46891_2_.getPotion()) & 0xFF);
        this.amplifier = (byte)(p_i46891_2_.getAmplifier() & 0xFF);
        this.duration = p_i46891_2_.getDuration() > Short.MAX_VALUE ? Short.MAX_VALUE : p_i46891_2_.getDuration();
        this.flags = 0;
        if (p_i46891_2_.getIsAmbient()) {
            this.flags = (byte)(this.flags | 1);
        }
        if (p_i46891_2_.doesShowParticles()) {
            this.flags = (byte)(this.flags | 2);
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.effectId = p_readPacketData_1_.readByte();
        this.amplifier = p_readPacketData_1_.readByte();
        this.duration = p_readPacketData_1_.readVarInt();
        this.flags = p_readPacketData_1_.readByte();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeByte(this.effectId);
        p_writePacketData_1_.writeByte(this.amplifier);
        p_writePacketData_1_.writeVarInt(this.duration);
        p_writePacketData_1_.writeByte(this.flags);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isMaxDuration() {
        return this.duration == Short.MAX_VALUE;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleEntityEffect(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getEffectId() {
        return this.effectId;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getAmplifier() {
        return this.amplifier;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDuration() {
        return this.duration;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean doesShowParticles() {
        return (this.flags & 2) == 2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getIsAmbient() {
        return (this.flags & 1) == 1;
    }
}

