/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityEquipment
implements Packet<INetHandlerPlayClient> {
    private int entityID;
    private EntityEquipmentSlot equipmentSlot;
    private ItemStack itemStack = ItemStack.EMPTY;

    public SPacketEntityEquipment() {
    }

    public SPacketEntityEquipment(int p_i46913_1_, EntityEquipmentSlot p_i46913_2_, ItemStack p_i46913_3_) {
        this.entityID = p_i46913_1_;
        this.equipmentSlot = p_i46913_2_;
        this.itemStack = p_i46913_3_.isEmpty() ? ItemStack.EMPTY : p_i46913_3_.copy();
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityID = p_readPacketData_1_.readVarInt();
        this.equipmentSlot = p_readPacketData_1_.readEnumValue(EntityEquipmentSlot.class);
        this.itemStack = p_readPacketData_1_.readItemStack();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityID);
        p_writePacketData_1_.writeEnumValue(this.equipmentSlot);
        p_writePacketData_1_.writeItemStack(this.itemStack);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleEntityEquipment(this);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityID() {
        return this.entityID;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityEquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }
}

