/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.List;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityMetadata
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private List<EntityDataManager.DataEntry<?>> dataManagerEntries;

    public SPacketEntityMetadata() {
    }

    public SPacketEntityMetadata(int p_i46917_1_, EntityDataManager p_i46917_2_, boolean p_i46917_3_) {
        this.entityId = p_i46917_1_;
        if (p_i46917_3_) {
            this.dataManagerEntries = p_i46917_2_.getAll();
            p_i46917_2_.setClean();
        } else {
            this.dataManagerEntries = p_i46917_2_.getDirty();
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.dataManagerEntries = EntityDataManager.readEntries(p_readPacketData_1_);
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        EntityDataManager.writeEntries(this.dataManagerEntries, p_writePacketData_1_);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleEntityMetadata(this);
    }

    @SideOnly(value=Side.CLIENT)
    public List<EntityDataManager.DataEntry<?>> getDataManagerEntries() {
        return this.dataManagerEntries;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }
}

