/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityProperties
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private final List<Snapshot> snapshots = Lists.newArrayList();

    public SPacketEntityProperties() {
    }

    public SPacketEntityProperties(int p_i46892_1_, Collection<IAttributeInstance> p_i46892_2_) {
        this.entityId = p_i46892_1_;
        for (IAttributeInstance lvt_4_1_ : p_i46892_2_) {
            this.snapshots.add(new Snapshot(lvt_4_1_.getAttribute().getName(), lvt_4_1_.getBaseValue(), lvt_4_1_.getModifiers()));
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        int lvt_2_1_ = p_readPacketData_1_.readInt();
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            String lvt_4_1_ = p_readPacketData_1_.readString(64);
            double lvt_5_1_ = p_readPacketData_1_.readDouble();
            ArrayList lvt_7_1_ = Lists.newArrayList();
            int lvt_8_1_ = p_readPacketData_1_.readVarInt();
            for (int lvt_9_1_ = 0; lvt_9_1_ < lvt_8_1_; ++lvt_9_1_) {
                UUID lvt_10_1_ = p_readPacketData_1_.readUniqueId();
                lvt_7_1_.add(new AttributeModifier(lvt_10_1_, "Unknown synced attribute modifier", p_readPacketData_1_.readDouble(), p_readPacketData_1_.readByte()));
            }
            this.snapshots.add(new Snapshot(lvt_4_1_, lvt_5_1_, lvt_7_1_));
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeInt(this.snapshots.size());
        for (Snapshot lvt_3_1_ : this.snapshots) {
            p_writePacketData_1_.writeString(lvt_3_1_.getName());
            p_writePacketData_1_.writeDouble(lvt_3_1_.getBaseValue());
            p_writePacketData_1_.writeVarInt(lvt_3_1_.getModifiers().size());
            for (AttributeModifier lvt_5_1_ : lvt_3_1_.getModifiers()) {
                p_writePacketData_1_.writeUniqueId(lvt_5_1_.getID());
                p_writePacketData_1_.writeDouble(lvt_5_1_.getAmount());
                p_writePacketData_1_.writeByte(lvt_5_1_.getOperation());
            }
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleEntityProperties(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public List<Snapshot> getSnapshots() {
        return this.snapshots;
    }

    public class Snapshot {
        private final String name;
        private final double baseValue;
        private final Collection<AttributeModifier> modifiers;

        public Snapshot(String p_i47075_2_, double p_i47075_3_, Collection<AttributeModifier> p_i47075_5_) {
            this.name = p_i47075_2_;
            this.baseValue = p_i47075_3_;
            this.modifiers = p_i47075_5_;
        }

        public String getName() {
            return this.name;
        }

        public double getBaseValue() {
            return this.baseValue;
        }

        public Collection<AttributeModifier> getModifiers() {
            return this.modifiers;
        }
    }
}

