/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketEntityTeleport
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private double posX;
    private double posY;
    private double posZ;
    private byte yaw;
    private byte pitch;
    private boolean onGround;

    public SPacketEntityTeleport() {
    }

    public SPacketEntityTeleport(Entity p_i46893_1_) {
        this.entityId = p_i46893_1_.getEntityId();
        this.posX = p_i46893_1_.posX;
        this.posY = p_i46893_1_.posY;
        this.posZ = p_i46893_1_.posZ;
        this.yaw = (byte)(p_i46893_1_.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(p_i46893_1_.rotationPitch * 256.0f / 360.0f);
        this.onGround = p_i46893_1_.onGround;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.posX = p_readPacketData_1_.readDouble();
        this.posY = p_readPacketData_1_.readDouble();
        this.posZ = p_readPacketData_1_.readDouble();
        this.yaw = p_readPacketData_1_.readByte();
        this.pitch = p_readPacketData_1_.readByte();
        this.onGround = p_readPacketData_1_.readBoolean();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeDouble(this.posX);
        p_writePacketData_1_.writeDouble(this.posY);
        p_writePacketData_1_.writeDouble(this.posZ);
        p_writePacketData_1_.writeByte(this.yaw);
        p_writePacketData_1_.writeByte(this.pitch);
        p_writePacketData_1_.writeBoolean(this.onGround);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleEntityTeleport(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.posX;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.posY;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.posZ;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getOnGround() {
        return this.onGround;
    }
}

