/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketExplosion
implements Packet<INetHandlerPlayClient> {
    private double posX;
    private double posY;
    private double posZ;
    private float strength;
    private List<BlockPos> affectedBlockPositions;
    private float motionX;
    private float motionY;
    private float motionZ;

    public SPacketExplosion() {
    }

    public SPacketExplosion(double p_i47099_1_, double p_i47099_3_, double p_i47099_5_, float p_i47099_7_, List<BlockPos> p_i47099_8_, Vec3d p_i47099_9_) {
        this.posX = p_i47099_1_;
        this.posY = p_i47099_3_;
        this.posZ = p_i47099_5_;
        this.strength = p_i47099_7_;
        this.affectedBlockPositions = Lists.newArrayList(p_i47099_8_);
        if (p_i47099_9_ != null) {
            this.motionX = (float)p_i47099_9_.xCoord;
            this.motionY = (float)p_i47099_9_.yCoord;
            this.motionZ = (float)p_i47099_9_.zCoord;
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.posX = p_readPacketData_1_.readFloat();
        this.posY = p_readPacketData_1_.readFloat();
        this.posZ = p_readPacketData_1_.readFloat();
        this.strength = p_readPacketData_1_.readFloat();
        int lvt_2_1_ = p_readPacketData_1_.readInt();
        this.affectedBlockPositions = Lists.newArrayListWithCapacity((int)lvt_2_1_);
        int lvt_3_1_ = (int)this.posX;
        int lvt_4_1_ = (int)this.posY;
        int lvt_5_1_ = (int)this.posZ;
        for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_2_1_; ++lvt_6_1_) {
            int lvt_7_1_ = p_readPacketData_1_.readByte() + lvt_3_1_;
            int lvt_8_1_ = p_readPacketData_1_.readByte() + lvt_4_1_;
            int lvt_9_1_ = p_readPacketData_1_.readByte() + lvt_5_1_;
            this.affectedBlockPositions.add(new BlockPos(lvt_7_1_, lvt_8_1_, lvt_9_1_));
        }
        this.motionX = p_readPacketData_1_.readFloat();
        this.motionY = p_readPacketData_1_.readFloat();
        this.motionZ = p_readPacketData_1_.readFloat();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeFloat((float)this.posX);
        p_writePacketData_1_.writeFloat((float)this.posY);
        p_writePacketData_1_.writeFloat((float)this.posZ);
        p_writePacketData_1_.writeFloat(this.strength);
        p_writePacketData_1_.writeInt(this.affectedBlockPositions.size());
        int lvt_2_1_ = (int)this.posX;
        int lvt_3_1_ = (int)this.posY;
        int lvt_4_1_ = (int)this.posZ;
        for (BlockPos lvt_6_1_ : this.affectedBlockPositions) {
            int lvt_7_1_ = lvt_6_1_.getX() - lvt_2_1_;
            int lvt_8_1_ = lvt_6_1_.getY() - lvt_3_1_;
            int lvt_9_1_ = lvt_6_1_.getZ() - lvt_4_1_;
            p_writePacketData_1_.writeByte(lvt_7_1_);
            p_writePacketData_1_.writeByte(lvt_8_1_);
            p_writePacketData_1_.writeByte(lvt_9_1_);
        }
        p_writePacketData_1_.writeFloat(this.motionX);
        p_writePacketData_1_.writeFloat(this.motionY);
        p_writePacketData_1_.writeFloat(this.motionZ);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleExplosion(this);
    }

    @SideOnly(value=Side.CLIENT)
    public float getMotionX() {
        return this.motionX;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMotionY() {
        return this.motionY;
    }

    @SideOnly(value=Side.CLIENT)
    public float getMotionZ() {
        return this.motionZ;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.posX;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.posY;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.posZ;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStrength() {
        return this.strength;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }
}

