/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketJoinGame
implements Packet<INetHandlerPlayClient> {
    private int playerId;
    private boolean hardcoreMode;
    private GameType gameType;
    private int dimension;
    private EnumDifficulty difficulty;
    private int maxPlayers;
    private WorldType worldType;
    private boolean reducedDebugInfo;

    public SPacketJoinGame() {
    }

    public SPacketJoinGame(int p_i46938_1_, GameType p_i46938_2_, boolean p_i46938_3_, int p_i46938_4_, EnumDifficulty p_i46938_5_, int p_i46938_6_, WorldType p_i46938_7_, boolean p_i46938_8_) {
        this.playerId = p_i46938_1_;
        this.dimension = p_i46938_4_;
        this.difficulty = p_i46938_5_;
        this.gameType = p_i46938_2_;
        this.maxPlayers = p_i46938_6_;
        this.hardcoreMode = p_i46938_3_;
        this.worldType = p_i46938_7_;
        this.reducedDebugInfo = p_i46938_8_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.playerId = p_readPacketData_1_.readInt();
        int lvt_2_1_ = p_readPacketData_1_.readUnsignedByte();
        this.hardcoreMode = (lvt_2_1_ & 8) == 8;
        this.gameType = GameType.getByID(lvt_2_1_ &= 0xFFFFFFF7);
        this.dimension = p_readPacketData_1_.readInt();
        this.difficulty = EnumDifficulty.getDifficultyEnum(p_readPacketData_1_.readUnsignedByte());
        this.maxPlayers = p_readPacketData_1_.readUnsignedByte();
        this.worldType = WorldType.parseWorldType(p_readPacketData_1_.readString(16));
        if (this.worldType == null) {
            this.worldType = WorldType.DEFAULT;
        }
        this.reducedDebugInfo = p_readPacketData_1_.readBoolean();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeInt(this.playerId);
        int lvt_2_1_ = this.gameType.getID();
        if (this.hardcoreMode) {
            lvt_2_1_ |= 8;
        }
        p_writePacketData_1_.writeByte(lvt_2_1_);
        p_writePacketData_1_.writeInt(this.dimension);
        p_writePacketData_1_.writeByte(this.difficulty.getDifficultyId());
        p_writePacketData_1_.writeByte(this.maxPlayers);
        p_writePacketData_1_.writeString(this.worldType.getName());
        p_writePacketData_1_.writeBoolean(this.reducedDebugInfo);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleJoinGame(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getPlayerId() {
        return this.playerId;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isHardcoreMode() {
        return this.hardcoreMode;
    }

    @SideOnly(value=Side.CLIENT)
    public GameType getGameType() {
        return this.gameType;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDimension() {
        return this.dimension;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType getWorldType() {
        return this.worldType;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }
}

