/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.Collection;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketMaps
implements Packet<INetHandlerPlayClient> {
    private int mapId;
    private byte mapScale;
    private boolean trackingPosition;
    private MapDecoration[] icons;
    private int minX;
    private int minZ;
    private int columns;
    private int rows;
    private byte[] mapDataBytes;

    public SPacketMaps() {
    }

    public SPacketMaps(int p_i46937_1_, byte p_i46937_2_, boolean p_i46937_3_, Collection<MapDecoration> p_i46937_4_, byte[] p_i46937_5_, int p_i46937_6_, int p_i46937_7_, int p_i46937_8_, int p_i46937_9_) {
        this.mapId = p_i46937_1_;
        this.mapScale = p_i46937_2_;
        this.trackingPosition = p_i46937_3_;
        this.icons = p_i46937_4_.toArray(new MapDecoration[p_i46937_4_.size()]);
        this.minX = p_i46937_6_;
        this.minZ = p_i46937_7_;
        this.columns = p_i46937_8_;
        this.rows = p_i46937_9_;
        this.mapDataBytes = new byte[p_i46937_8_ * p_i46937_9_];
        for (int lvt_10_1_ = 0; lvt_10_1_ < p_i46937_8_; ++lvt_10_1_) {
            for (int lvt_11_1_ = 0; lvt_11_1_ < p_i46937_9_; ++lvt_11_1_) {
                this.mapDataBytes[lvt_10_1_ + lvt_11_1_ * p_i46937_8_] = p_i46937_5_[p_i46937_6_ + lvt_10_1_ + (p_i46937_7_ + lvt_11_1_) * 128];
            }
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.mapId = p_readPacketData_1_.readVarInt();
        this.mapScale = p_readPacketData_1_.readByte();
        this.trackingPosition = p_readPacketData_1_.readBoolean();
        this.icons = new MapDecoration[p_readPacketData_1_.readVarInt()];
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.icons.length; ++lvt_2_1_) {
            short lvt_3_1_ = p_readPacketData_1_.readByte();
            this.icons[lvt_2_1_] = new MapDecoration(MapDecoration.Type.byIcon((byte)(lvt_3_1_ >> 4 & 0xF)), p_readPacketData_1_.readByte(), p_readPacketData_1_.readByte(), (byte)(lvt_3_1_ & 0xF));
        }
        this.columns = p_readPacketData_1_.readUnsignedByte();
        if (this.columns > 0) {
            this.rows = p_readPacketData_1_.readUnsignedByte();
            this.minX = p_readPacketData_1_.readUnsignedByte();
            this.minZ = p_readPacketData_1_.readUnsignedByte();
            this.mapDataBytes = p_readPacketData_1_.readByteArray();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.mapId);
        p_writePacketData_1_.writeByte(this.mapScale);
        p_writePacketData_1_.writeBoolean(this.trackingPosition);
        p_writePacketData_1_.writeVarInt(this.icons.length);
        for (MapDecoration lvt_5_1_ : this.icons) {
            p_writePacketData_1_.writeByte((lvt_5_1_.getImage() & 0xF) << 4 | lvt_5_1_.getRotation() & 0xF);
            p_writePacketData_1_.writeByte(lvt_5_1_.getX());
            p_writePacketData_1_.writeByte(lvt_5_1_.getY());
        }
        p_writePacketData_1_.writeByte(this.columns);
        if (this.columns > 0) {
            p_writePacketData_1_.writeByte(this.rows);
            p_writePacketData_1_.writeByte(this.minX);
            p_writePacketData_1_.writeByte(this.minZ);
            p_writePacketData_1_.writeByteArray(this.mapDataBytes);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleMaps(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getMapId() {
        return this.mapId;
    }

    @SideOnly(value=Side.CLIENT)
    public void setMapdataTo(MapData p_setMapdataTo_1_) {
        p_setMapdataTo_1_.scale = this.mapScale;
        p_setMapdataTo_1_.trackingPosition = this.trackingPosition;
        p_setMapdataTo_1_.mapDecorations.clear();
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.icons.length; ++lvt_2_1_) {
            MapDecoration lvt_3_1_ = this.icons[lvt_2_1_];
            p_setMapdataTo_1_.mapDecorations.put("icon-" + lvt_2_1_, lvt_3_1_);
        }
        for (int lvt_2_2_ = 0; lvt_2_2_ < this.columns; ++lvt_2_2_) {
            for (int lvt_3_2_ = 0; lvt_3_2_ < this.rows; ++lvt_3_2_) {
                p_setMapdataTo_1_.colors[this.minX + lvt_2_2_ + (this.minZ + lvt_3_2_) * 128] = this.mapDataBytes[lvt_2_2_ + lvt_3_2_ * this.columns];
            }
        }
    }
}

