/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketMultiBlockChange
implements Packet<INetHandlerPlayClient> {
    private ChunkPos chunkPos;
    private BlockUpdateData[] changedBlocks;

    public SPacketMultiBlockChange() {
    }

    public SPacketMultiBlockChange(int p_i46959_1_, short[] p_i46959_2_, Chunk p_i46959_3_) {
        this.chunkPos = new ChunkPos(p_i46959_3_.xPosition, p_i46959_3_.zPosition);
        this.changedBlocks = new BlockUpdateData[p_i46959_1_];
        for (int lvt_4_1_ = 0; lvt_4_1_ < this.changedBlocks.length; ++lvt_4_1_) {
            this.changedBlocks[lvt_4_1_] = new BlockUpdateData(p_i46959_2_[lvt_4_1_], p_i46959_3_);
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.chunkPos = new ChunkPos(p_readPacketData_1_.readInt(), p_readPacketData_1_.readInt());
        this.changedBlocks = new BlockUpdateData[p_readPacketData_1_.readVarInt()];
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.changedBlocks.length; ++lvt_2_1_) {
            this.changedBlocks[lvt_2_1_] = new BlockUpdateData(p_readPacketData_1_.readShort(), Block.BLOCK_STATE_IDS.getByValue(p_readPacketData_1_.readVarInt()));
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeInt(this.chunkPos.chunkXPos);
        p_writePacketData_1_.writeInt(this.chunkPos.chunkZPos);
        p_writePacketData_1_.writeVarInt(this.changedBlocks.length);
        for (BlockUpdateData lvt_5_1_ : this.changedBlocks) {
            p_writePacketData_1_.writeShort(lvt_5_1_.getOffset());
            p_writePacketData_1_.writeVarInt(Block.BLOCK_STATE_IDS.get(lvt_5_1_.getBlockState()));
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleMultiBlockChange(this);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockUpdateData[] getChangedBlocks() {
        return this.changedBlocks;
    }

    public class BlockUpdateData {
        private final short offset;
        private final IBlockState blockState;

        public BlockUpdateData(short p_i46544_2_, IBlockState p_i46544_3_) {
            this.offset = p_i46544_2_;
            this.blockState = p_i46544_3_;
        }

        public BlockUpdateData(short p_i46545_2_, Chunk p_i46545_3_) {
            this.offset = p_i46545_2_;
            this.blockState = p_i46545_3_.getBlockState(this.getPos());
        }

        public BlockPos getPos() {
            return new BlockPos(SPacketMultiBlockChange.this.chunkPos.getBlock(this.offset >> 12 & 0xF, this.offset & 0xFF, this.offset >> 8 & 0xF));
        }

        public short getOffset() {
            return this.offset;
        }

        public IBlockState getBlockState() {
            return this.blockState;
        }
    }
}

