/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketOpenWindow
implements Packet<INetHandlerPlayClient> {
    private int windowId;
    private String inventoryType;
    private ITextComponent windowTitle;
    private int slotCount;
    private int entityId;

    public SPacketOpenWindow() {
    }

    public SPacketOpenWindow(int p_i46954_1_, String p_i46954_2_, ITextComponent p_i46954_3_) {
        this(p_i46954_1_, p_i46954_2_, p_i46954_3_, 0);
    }

    public SPacketOpenWindow(int p_i46955_1_, String p_i46955_2_, ITextComponent p_i46955_3_, int p_i46955_4_) {
        this.windowId = p_i46955_1_;
        this.inventoryType = p_i46955_2_;
        this.windowTitle = p_i46955_3_;
        this.slotCount = p_i46955_4_;
    }

    public SPacketOpenWindow(int p_i46956_1_, String p_i46956_2_, ITextComponent p_i46956_3_, int p_i46956_4_, int p_i46956_5_) {
        this(p_i46956_1_, p_i46956_2_, p_i46956_3_, p_i46956_4_);
        this.entityId = p_i46956_5_;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleOpenWindow(this);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.windowId = p_readPacketData_1_.readUnsignedByte();
        this.inventoryType = p_readPacketData_1_.readString(32);
        this.windowTitle = p_readPacketData_1_.readTextComponent();
        this.slotCount = p_readPacketData_1_.readUnsignedByte();
        if (this.inventoryType.equals("EntityHorse")) {
            this.entityId = p_readPacketData_1_.readInt();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeByte(this.windowId);
        p_writePacketData_1_.writeString(this.inventoryType);
        p_writePacketData_1_.writeTextComponent(this.windowTitle);
        p_writePacketData_1_.writeByte(this.slotCount);
        if (this.inventoryType.equals("EntityHorse")) {
            p_writePacketData_1_.writeInt(this.entityId);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getWindowId() {
        return this.windowId;
    }

    @SideOnly(value=Side.CLIENT)
    public String getGuiId() {
        return this.inventoryType;
    }

    @SideOnly(value=Side.CLIENT)
    public ITextComponent getWindowTitle() {
        return this.windowTitle;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSlotCount() {
        return this.slotCount;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityId() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasSlots() {
        return this.slotCount > 0;
    }
}

