/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketParticles
implements Packet<INetHandlerPlayClient> {
    private EnumParticleTypes particleType;
    private float xCoord;
    private float yCoord;
    private float zCoord;
    private float xOffset;
    private float yOffset;
    private float zOffset;
    private float particleSpeed;
    private int particleCount;
    private boolean longDistance;
    private int[] particleArguments;

    public SPacketParticles() {
    }

    public SPacketParticles(EnumParticleTypes p_i46939_1_, boolean p_i46939_2_, float p_i46939_3_, float p_i46939_4_, float p_i46939_5_, float p_i46939_6_, float p_i46939_7_, float p_i46939_8_, float p_i46939_9_, int p_i46939_10_, int ... p_i46939_11_) {
        this.particleType = p_i46939_1_;
        this.longDistance = p_i46939_2_;
        this.xCoord = p_i46939_3_;
        this.yCoord = p_i46939_4_;
        this.zCoord = p_i46939_5_;
        this.xOffset = p_i46939_6_;
        this.yOffset = p_i46939_7_;
        this.zOffset = p_i46939_8_;
        this.particleSpeed = p_i46939_9_;
        this.particleCount = p_i46939_10_;
        this.particleArguments = p_i46939_11_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.particleType = EnumParticleTypes.getParticleFromId(p_readPacketData_1_.readInt());
        if (this.particleType == null) {
            this.particleType = EnumParticleTypes.BARRIER;
        }
        this.longDistance = p_readPacketData_1_.readBoolean();
        this.xCoord = p_readPacketData_1_.readFloat();
        this.yCoord = p_readPacketData_1_.readFloat();
        this.zCoord = p_readPacketData_1_.readFloat();
        this.xOffset = p_readPacketData_1_.readFloat();
        this.yOffset = p_readPacketData_1_.readFloat();
        this.zOffset = p_readPacketData_1_.readFloat();
        this.particleSpeed = p_readPacketData_1_.readFloat();
        this.particleCount = p_readPacketData_1_.readInt();
        int lvt_2_1_ = this.particleType.getArgumentCount();
        this.particleArguments = new int[lvt_2_1_];
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            this.particleArguments[lvt_3_1_] = p_readPacketData_1_.readVarInt();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeInt(this.particleType.getParticleID());
        p_writePacketData_1_.writeBoolean(this.longDistance);
        p_writePacketData_1_.writeFloat(this.xCoord);
        p_writePacketData_1_.writeFloat(this.yCoord);
        p_writePacketData_1_.writeFloat(this.zCoord);
        p_writePacketData_1_.writeFloat(this.xOffset);
        p_writePacketData_1_.writeFloat(this.yOffset);
        p_writePacketData_1_.writeFloat(this.zOffset);
        p_writePacketData_1_.writeFloat(this.particleSpeed);
        p_writePacketData_1_.writeInt(this.particleCount);
        int lvt_2_1_ = this.particleType.getArgumentCount();
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            p_writePacketData_1_.writeVarInt(this.particleArguments[lvt_3_1_]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumParticleTypes getParticleType() {
        return this.particleType;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleParticles(this);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isLongDistance() {
        return this.longDistance;
    }

    @SideOnly(value=Side.CLIENT)
    public double getXCoordinate() {
        return this.xCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public double getYCoordinate() {
        return this.yCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZCoordinate() {
        return this.zCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public float getXOffset() {
        return this.xOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getYOffset() {
        return this.yOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getZOffset() {
        return this.zOffset;
    }

    @SideOnly(value=Side.CLIENT)
    public float getParticleSpeed() {
        return this.particleSpeed;
    }

    @SideOnly(value=Side.CLIENT)
    public int getParticleCount() {
        return this.particleCount;
    }

    @SideOnly(value=Side.CLIENT)
    public int[] getParticleArgs() {
        return this.particleArguments;
    }
}

