/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketPlayerAbilities
implements Packet<INetHandlerPlayClient> {
    private boolean invulnerable;
    private boolean flying;
    private boolean allowFlying;
    private boolean creativeMode;
    private float flySpeed;
    private float walkSpeed;

    public SPacketPlayerAbilities() {
    }

    public SPacketPlayerAbilities(PlayerCapabilities p_i46933_1_) {
        this.setInvulnerable(p_i46933_1_.disableDamage);
        this.setFlying(p_i46933_1_.isFlying);
        this.setAllowFlying(p_i46933_1_.allowFlying);
        this.setCreativeMode(p_i46933_1_.isCreativeMode);
        this.setFlySpeed(p_i46933_1_.getFlySpeed());
        this.setWalkSpeed(p_i46933_1_.getWalkSpeed());
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        byte lvt_2_1_ = p_readPacketData_1_.readByte();
        this.setInvulnerable((lvt_2_1_ & 1) > 0);
        this.setFlying((lvt_2_1_ & 2) > 0);
        this.setAllowFlying((lvt_2_1_ & 4) > 0);
        this.setCreativeMode((lvt_2_1_ & 8) > 0);
        this.setFlySpeed(p_readPacketData_1_.readFloat());
        this.setWalkSpeed(p_readPacketData_1_.readFloat());
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        byte lvt_2_1_ = 0;
        if (this.isInvulnerable()) {
            lvt_2_1_ = (byte)(lvt_2_1_ | 1);
        }
        if (this.isFlying()) {
            lvt_2_1_ = (byte)(lvt_2_1_ | 2);
        }
        if (this.isAllowFlying()) {
            lvt_2_1_ = (byte)(lvt_2_1_ | 4);
        }
        if (this.isCreativeMode()) {
            lvt_2_1_ = (byte)(lvt_2_1_ | 8);
        }
        p_writePacketData_1_.writeByte(lvt_2_1_);
        p_writePacketData_1_.writeFloat(this.flySpeed);
        p_writePacketData_1_.writeFloat(this.walkSpeed);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handlePlayerAbilities(this);
    }

    public boolean isInvulnerable() {
        return this.invulnerable;
    }

    public void setInvulnerable(boolean p_setInvulnerable_1_) {
        this.invulnerable = p_setInvulnerable_1_;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean p_setFlying_1_) {
        this.flying = p_setFlying_1_;
    }

    public boolean isAllowFlying() {
        return this.allowFlying;
    }

    public void setAllowFlying(boolean p_setAllowFlying_1_) {
        this.allowFlying = p_setAllowFlying_1_;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public void setCreativeMode(boolean p_setCreativeMode_1_) {
        this.creativeMode = p_setCreativeMode_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getFlySpeed() {
        return this.flySpeed;
    }

    public void setFlySpeed(float p_setFlySpeed_1_) {
        this.flySpeed = p_setFlySpeed_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public float getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setWalkSpeed(float p_setWalkSpeed_1_) {
        this.walkSpeed = p_setWalkSpeed_1_;
    }
}

