/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketPlayerListItem
implements Packet<INetHandlerPlayClient> {
    private Action action;
    private final List<AddPlayerData> players = Lists.newArrayList();

    public SPacketPlayerListItem() {
    }

    public SPacketPlayerListItem(Action p_i46929_1_, EntityPlayerMP ... p_i46929_2_) {
        this.action = p_i46929_1_;
        for (EntityPlayerMP lvt_6_1_ : p_i46929_2_) {
            this.players.add(new AddPlayerData(lvt_6_1_.getGameProfile(), lvt_6_1_.ping, lvt_6_1_.interactionManager.getGameType(), lvt_6_1_.getTabListDisplayName()));
        }
    }

    public SPacketPlayerListItem(Action p_i46930_1_, Iterable<EntityPlayerMP> p_i46930_2_) {
        this.action = p_i46930_1_;
        for (EntityPlayerMP lvt_4_1_ : p_i46930_2_) {
            this.players.add(new AddPlayerData(lvt_4_1_.getGameProfile(), lvt_4_1_.ping, lvt_4_1_.interactionManager.getGameType(), lvt_4_1_.getTabListDisplayName()));
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.action = p_readPacketData_1_.readEnumValue(Action.class);
        int lvt_2_1_ = p_readPacketData_1_.readVarInt();
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            GameProfile lvt_4_1_ = null;
            int lvt_5_1_ = 0;
            GameType lvt_6_1_ = null;
            ITextComponent lvt_7_1_ = null;
            switch (this.action) {
                case ADD_PLAYER: {
                    lvt_4_1_ = new GameProfile(p_readPacketData_1_.readUniqueId(), p_readPacketData_1_.readString(16));
                    int lvt_8_1_ = p_readPacketData_1_.readVarInt();
                    for (int lvt_9_1_ = 0; lvt_9_1_ < lvt_8_1_; ++lvt_9_1_) {
                        String lvt_10_1_ = p_readPacketData_1_.readString(Short.MAX_VALUE);
                        String lvt_11_1_ = p_readPacketData_1_.readString(Short.MAX_VALUE);
                        if (p_readPacketData_1_.readBoolean()) {
                            lvt_4_1_.getProperties().put((Object)lvt_10_1_, (Object)new Property(lvt_10_1_, lvt_11_1_, p_readPacketData_1_.readString(Short.MAX_VALUE)));
                            continue;
                        }
                        lvt_4_1_.getProperties().put((Object)lvt_10_1_, (Object)new Property(lvt_10_1_, lvt_11_1_));
                    }
                    lvt_6_1_ = GameType.getByID(p_readPacketData_1_.readVarInt());
                    lvt_5_1_ = p_readPacketData_1_.readVarInt();
                    if (!p_readPacketData_1_.readBoolean()) break;
                    lvt_7_1_ = p_readPacketData_1_.readTextComponent();
                    break;
                }
                case UPDATE_GAME_MODE: {
                    lvt_4_1_ = new GameProfile(p_readPacketData_1_.readUniqueId(), null);
                    lvt_6_1_ = GameType.getByID(p_readPacketData_1_.readVarInt());
                    break;
                }
                case UPDATE_LATENCY: {
                    lvt_4_1_ = new GameProfile(p_readPacketData_1_.readUniqueId(), null);
                    lvt_5_1_ = p_readPacketData_1_.readVarInt();
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    lvt_4_1_ = new GameProfile(p_readPacketData_1_.readUniqueId(), null);
                    if (!p_readPacketData_1_.readBoolean()) break;
                    lvt_7_1_ = p_readPacketData_1_.readTextComponent();
                    break;
                }
                case REMOVE_PLAYER: {
                    lvt_4_1_ = new GameProfile(p_readPacketData_1_.readUniqueId(), null);
                }
            }
            this.players.add(new AddPlayerData(lvt_4_1_, lvt_5_1_, lvt_6_1_, lvt_7_1_));
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeEnumValue(this.action);
        p_writePacketData_1_.writeVarInt(this.players.size());
        for (AddPlayerData lvt_3_1_ : this.players) {
            switch (this.action) {
                case ADD_PLAYER: {
                    p_writePacketData_1_.writeUniqueId(lvt_3_1_.getProfile().getId());
                    p_writePacketData_1_.writeString(lvt_3_1_.getProfile().getName());
                    p_writePacketData_1_.writeVarInt(lvt_3_1_.getProfile().getProperties().size());
                    for (Property lvt_5_1_ : lvt_3_1_.getProfile().getProperties().values()) {
                        p_writePacketData_1_.writeString(lvt_5_1_.getName());
                        p_writePacketData_1_.writeString(lvt_5_1_.getValue());
                        if (lvt_5_1_.hasSignature()) {
                            p_writePacketData_1_.writeBoolean(true);
                            p_writePacketData_1_.writeString(lvt_5_1_.getSignature());
                            continue;
                        }
                        p_writePacketData_1_.writeBoolean(false);
                    }
                    p_writePacketData_1_.writeVarInt(lvt_3_1_.getGameMode().getID());
                    p_writePacketData_1_.writeVarInt(lvt_3_1_.getPing());
                    if (lvt_3_1_.getDisplayName() == null) {
                        p_writePacketData_1_.writeBoolean(false);
                        break;
                    }
                    p_writePacketData_1_.writeBoolean(true);
                    p_writePacketData_1_.writeTextComponent(lvt_3_1_.getDisplayName());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    p_writePacketData_1_.writeUniqueId(lvt_3_1_.getProfile().getId());
                    p_writePacketData_1_.writeVarInt(lvt_3_1_.getGameMode().getID());
                    break;
                }
                case UPDATE_LATENCY: {
                    p_writePacketData_1_.writeUniqueId(lvt_3_1_.getProfile().getId());
                    p_writePacketData_1_.writeVarInt(lvt_3_1_.getPing());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    p_writePacketData_1_.writeUniqueId(lvt_3_1_.getProfile().getId());
                    if (lvt_3_1_.getDisplayName() == null) {
                        p_writePacketData_1_.writeBoolean(false);
                        break;
                    }
                    p_writePacketData_1_.writeBoolean(true);
                    p_writePacketData_1_.writeTextComponent(lvt_3_1_.getDisplayName());
                    break;
                }
                case REMOVE_PLAYER: {
                    p_writePacketData_1_.writeUniqueId(lvt_3_1_.getProfile().getId());
                }
            }
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handlePlayerListItem(this);
    }

    @SideOnly(value=Side.CLIENT)
    public List<AddPlayerData> getEntries() {
        return this.players;
    }

    @SideOnly(value=Side.CLIENT)
    public Action getAction() {
        return this.action;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("action", (Object)this.action).add("entries", this.players).toString();
    }

    public class AddPlayerData {
        private final int ping;
        private final GameType gamemode;
        private final GameProfile profile;
        private final ITextComponent displayName;

        public AddPlayerData(GameProfile p_i46663_2_, int p_i46663_3_, GameType p_i46663_4_, ITextComponent p_i46663_5_) {
            this.profile = p_i46663_2_;
            this.ping = p_i46663_3_;
            this.gamemode = p_i46663_4_;
            this.displayName = p_i46663_5_;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public int getPing() {
            return this.ping;
        }

        public GameType getGameMode() {
            return this.gamemode;
        }

        @Nullable
        public ITextComponent getDisplayName() {
            return this.displayName;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("latency", this.ping).add("gameMode", (Object)this.gamemode).add("profile", (Object)this.profile).add("displayName", this.displayName == null ? null : ITextComponent.Serializer.componentToJson(this.displayName)).toString();
        }
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }
}

