/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketPlayerPosLook
implements Packet<INetHandlerPlayClient> {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private Set<EnumFlags> flags;
    private int teleportId;

    public SPacketPlayerPosLook() {
    }

    public SPacketPlayerPosLook(double p_i46928_1_, double p_i46928_3_, double p_i46928_5_, float p_i46928_7_, float p_i46928_8_, Set<EnumFlags> p_i46928_9_, int p_i46928_10_) {
        this.x = p_i46928_1_;
        this.y = p_i46928_3_;
        this.z = p_i46928_5_;
        this.yaw = p_i46928_7_;
        this.pitch = p_i46928_8_;
        this.flags = p_i46928_9_;
        this.teleportId = p_i46928_10_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.x = p_readPacketData_1_.readDouble();
        this.y = p_readPacketData_1_.readDouble();
        this.z = p_readPacketData_1_.readDouble();
        this.yaw = p_readPacketData_1_.readFloat();
        this.pitch = p_readPacketData_1_.readFloat();
        this.flags = EnumFlags.unpack(p_readPacketData_1_.readUnsignedByte());
        this.teleportId = p_readPacketData_1_.readVarInt();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeDouble(this.x);
        p_writePacketData_1_.writeDouble(this.y);
        p_writePacketData_1_.writeDouble(this.z);
        p_writePacketData_1_.writeFloat(this.yaw);
        p_writePacketData_1_.writeFloat(this.pitch);
        p_writePacketData_1_.writeByte(EnumFlags.pack(this.flags));
        p_writePacketData_1_.writeVarInt(this.teleportId);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handlePlayerPosLook(this);
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.x;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.y;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.z;
    }

    @SideOnly(value=Side.CLIENT)
    public float getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTeleportId() {
        return this.teleportId;
    }

    @SideOnly(value=Side.CLIENT)
    public Set<EnumFlags> getFlags() {
        return this.flags;
    }

    public static enum EnumFlags {
        X(0),
        Y(1),
        Z(2),
        Y_ROT(3),
        X_ROT(4);

        private final int bit;

        private EnumFlags(int p_i46690_3_) {
            this.bit = p_i46690_3_;
        }

        private int getMask() {
            return 1 << this.bit;
        }

        private boolean isSet(int p_isSet_1_) {
            return (p_isSet_1_ & this.getMask()) == this.getMask();
        }

        public static Set<EnumFlags> unpack(int p_unpack_0_) {
            EnumSet<EnumFlags> lvt_1_1_ = EnumSet.noneOf(EnumFlags.class);
            for (EnumFlags lvt_5_1_ : EnumFlags.values()) {
                if (!lvt_5_1_.isSet(p_unpack_0_)) continue;
                lvt_1_1_.add(lvt_5_1_);
            }
            return lvt_1_1_;
        }

        public static int pack(Set<EnumFlags> p_pack_0_) {
            int lvt_1_1_ = 0;
            for (EnumFlags lvt_3_1_ : p_pack_0_) {
                lvt_1_1_ |= lvt_3_1_.getMask();
            }
            return lvt_1_1_;
        }
    }
}

