/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketRemoveEntityEffect
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private Potion effectId;

    public SPacketRemoveEntityEffect() {
    }

    public SPacketRemoveEntityEffect(int p_i46925_1_, Potion p_i46925_2_) {
        this.entityId = p_i46925_1_;
        this.effectId = p_i46925_2_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.effectId = Potion.getPotionById(p_readPacketData_1_.readUnsignedByte());
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeByte(Potion.getIdFromPotion(this.effectId));
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleRemoveEntityEffect(this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Entity getEntity(World p_getEntity_1_) {
        return p_getEntity_1_.getEntityByID(this.entityId);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Potion getPotion() {
        return this.effectId;
    }
}

