/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketRespawn
implements Packet<INetHandlerPlayClient> {
    private int dimensionID;
    private EnumDifficulty difficulty;
    private GameType gameType;
    private WorldType worldType;

    public SPacketRespawn() {
    }

    public SPacketRespawn(int p_i46923_1_, EnumDifficulty p_i46923_2_, WorldType p_i46923_3_, GameType p_i46923_4_) {
        this.dimensionID = p_i46923_1_;
        this.difficulty = p_i46923_2_;
        this.gameType = p_i46923_4_;
        this.worldType = p_i46923_3_;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleRespawn(this);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.dimensionID = p_readPacketData_1_.readInt();
        this.difficulty = EnumDifficulty.getDifficultyEnum(p_readPacketData_1_.readUnsignedByte());
        this.gameType = GameType.getByID(p_readPacketData_1_.readUnsignedByte());
        this.worldType = WorldType.parseWorldType(p_readPacketData_1_.readString(16));
        if (this.worldType == null) {
            this.worldType = WorldType.DEFAULT;
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeInt(this.dimensionID);
        p_writePacketData_1_.writeByte(this.difficulty.getDifficultyId());
        p_writePacketData_1_.writeByte(this.gameType.getID());
        p_writePacketData_1_.writeString(this.worldType.getName());
    }

    @SideOnly(value=Side.CLIENT)
    public int getDimensionID() {
        return this.dimensionID;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }

    @SideOnly(value=Side.CLIENT)
    public GameType getGameType() {
        return this.gameType;
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType getWorldType() {
        return this.worldType;
    }
}

