/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketScoreboardObjective
implements Packet<INetHandlerPlayClient> {
    private String objectiveName;
    private String objectiveValue;
    private IScoreCriteria.EnumRenderType type;
    private int action;

    public SPacketScoreboardObjective() {
    }

    public SPacketScoreboardObjective(ScoreObjective p_i46910_1_, int p_i46910_2_) {
        this.objectiveName = p_i46910_1_.getName();
        this.objectiveValue = p_i46910_1_.getDisplayName();
        this.type = p_i46910_1_.getCriteria().getRenderType();
        this.action = p_i46910_2_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.objectiveName = p_readPacketData_1_.readString(16);
        this.action = p_readPacketData_1_.readByte();
        if (this.action == 0 || this.action == 2) {
            this.objectiveValue = p_readPacketData_1_.readString(32);
            this.type = IScoreCriteria.EnumRenderType.getByName(p_readPacketData_1_.readString(16));
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.objectiveName);
        p_writePacketData_1_.writeByte(this.action);
        if (this.action == 0 || this.action == 2) {
            p_writePacketData_1_.writeString(this.objectiveValue);
            p_writePacketData_1_.writeString(this.type.getRenderType());
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleScoreboardObjective(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String getObjectiveName() {
        return this.objectiveName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getObjectiveValue() {
        return this.objectiveValue;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAction() {
        return this.action;
    }

    @SideOnly(value=Side.CLIENT)
    public IScoreCriteria.EnumRenderType getRenderType() {
        return this.type;
    }
}

