/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;

public class SPacketSoundEffect
implements Packet<INetHandlerPlayClient> {
    private SoundEvent sound;
    private SoundCategory category;
    private int posX;
    private int posY;
    private int posZ;
    private float soundVolume;
    private float soundPitch;

    public SPacketSoundEffect() {
    }

    public SPacketSoundEffect(SoundEvent p_i46896_1_, SoundCategory p_i46896_2_, double p_i46896_3_, double p_i46896_5_, double p_i46896_7_, float p_i46896_9_, float p_i46896_10_) {
        Validate.notNull((Object)p_i46896_1_, (String)"sound", (Object[])new Object[0]);
        this.sound = p_i46896_1_;
        this.category = p_i46896_2_;
        this.posX = (int)(p_i46896_3_ * 8.0);
        this.posY = (int)(p_i46896_5_ * 8.0);
        this.posZ = (int)(p_i46896_7_ * 8.0);
        this.soundVolume = p_i46896_9_;
        this.soundPitch = p_i46896_10_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.sound = SoundEvent.REGISTRY.getObjectById(p_readPacketData_1_.readVarInt());
        this.category = p_readPacketData_1_.readEnumValue(SoundCategory.class);
        this.posX = p_readPacketData_1_.readInt();
        this.posY = p_readPacketData_1_.readInt();
        this.posZ = p_readPacketData_1_.readInt();
        this.soundVolume = p_readPacketData_1_.readFloat();
        this.soundPitch = p_readPacketData_1_.readFloat();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(SoundEvent.REGISTRY.getIDForObject(this.sound));
        p_writePacketData_1_.writeEnumValue(this.category);
        p_writePacketData_1_.writeInt(this.posX);
        p_writePacketData_1_.writeInt(this.posY);
        p_writePacketData_1_.writeInt(this.posZ);
        p_writePacketData_1_.writeFloat(this.soundVolume);
        p_writePacketData_1_.writeFloat(this.soundPitch);
    }

    @SideOnly(value=Side.CLIENT)
    public SoundEvent getSound() {
        return this.sound;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleSoundEffect(this);
    }

    @SideOnly(value=Side.CLIENT)
    public SoundCategory getCategory() {
        return this.category;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return (float)this.posX / 8.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return (float)this.posY / 8.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return (float)this.posZ / 8.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getVolume() {
        return this.soundVolume;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPitch() {
        return this.soundPitch;
    }
}

