/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketSpawnMob
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private UUID uniqueId;
    private int type;
    private double x;
    private double y;
    private double z;
    private int velocityX;
    private int velocityY;
    private int velocityZ;
    private byte yaw;
    private byte pitch;
    private byte headPitch;
    private EntityDataManager dataManager;
    private List<EntityDataManager.DataEntry<?>> dataManagerEntries;

    public SPacketSpawnMob() {
    }

    public SPacketSpawnMob(EntityLivingBase p_i46973_1_) {
        this.entityId = p_i46973_1_.getEntityId();
        this.uniqueId = p_i46973_1_.getUniqueID();
        this.type = EntityList.getID(p_i46973_1_.getClass());
        this.x = p_i46973_1_.posX;
        this.y = p_i46973_1_.posY;
        this.z = p_i46973_1_.posZ;
        this.yaw = (byte)(p_i46973_1_.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(p_i46973_1_.rotationPitch * 256.0f / 360.0f);
        this.headPitch = (byte)(p_i46973_1_.rotationYawHead * 256.0f / 360.0f);
        double d0 = 3.9;
        double d1 = p_i46973_1_.motionX;
        double d2 = p_i46973_1_.motionY;
        double d3 = p_i46973_1_.motionZ;
        if (d1 < -3.9) {
            d1 = -3.9;
        }
        if (d2 < -3.9) {
            d2 = -3.9;
        }
        if (d3 < -3.9) {
            d3 = -3.9;
        }
        if (d1 > 3.9) {
            d1 = 3.9;
        }
        if (d2 > 3.9) {
            d2 = 3.9;
        }
        if (d3 > 3.9) {
            d3 = 3.9;
        }
        this.velocityX = (int)(d1 * 8000.0);
        this.velocityY = (int)(d2 * 8000.0);
        this.velocityZ = (int)(d3 * 8000.0);
        this.dataManager = p_i46973_1_.getDataManager();
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.uniqueId = p_readPacketData_1_.readUniqueId();
        this.type = p_readPacketData_1_.readVarInt();
        this.x = p_readPacketData_1_.readDouble();
        this.y = p_readPacketData_1_.readDouble();
        this.z = p_readPacketData_1_.readDouble();
        this.yaw = p_readPacketData_1_.readByte();
        this.pitch = p_readPacketData_1_.readByte();
        this.headPitch = p_readPacketData_1_.readByte();
        this.velocityX = p_readPacketData_1_.readShort();
        this.velocityY = p_readPacketData_1_.readShort();
        this.velocityZ = p_readPacketData_1_.readShort();
        this.dataManagerEntries = EntityDataManager.readEntries(p_readPacketData_1_);
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeUniqueId(this.uniqueId);
        p_writePacketData_1_.writeVarInt(this.type);
        p_writePacketData_1_.writeDouble(this.x);
        p_writePacketData_1_.writeDouble(this.y);
        p_writePacketData_1_.writeDouble(this.z);
        p_writePacketData_1_.writeByte(this.yaw);
        p_writePacketData_1_.writeByte(this.pitch);
        p_writePacketData_1_.writeByte(this.headPitch);
        p_writePacketData_1_.writeShort(this.velocityX);
        p_writePacketData_1_.writeShort(this.velocityY);
        p_writePacketData_1_.writeShort(this.velocityZ);
        this.dataManager.writeEntries(p_writePacketData_1_);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleSpawnMob(this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<EntityDataManager.DataEntry<?>> getDataManagerEntries() {
        return this.dataManagerEntries;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityID() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.x;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.y;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.z;
    }

    @SideOnly(value=Side.CLIENT)
    public int getVelocityX() {
        return this.velocityX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getVelocityY() {
        return this.velocityY;
    }

    @SideOnly(value=Side.CLIENT)
    public int getVelocityZ() {
        return this.velocityZ;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getHeadPitch() {
        return this.headPitch;
    }
}

