/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketSpawnObject
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private int speedX;
    private int speedY;
    private int speedZ;
    private int pitch;
    private int yaw;
    private int type;
    private int data;

    public SPacketSpawnObject() {
    }

    public SPacketSpawnObject(Entity p_i46976_1_, int p_i46976_2_) {
        this(p_i46976_1_, p_i46976_2_, 0);
    }

    public SPacketSpawnObject(Entity p_i46977_1_, int p_i46977_2_, int p_i46977_3_) {
        this.entityId = p_i46977_1_.getEntityId();
        this.uniqueId = p_i46977_1_.getUniqueID();
        this.x = p_i46977_1_.posX;
        this.y = p_i46977_1_.posY;
        this.z = p_i46977_1_.posZ;
        this.pitch = MathHelper.floor(p_i46977_1_.rotationPitch * 256.0f / 360.0f);
        this.yaw = MathHelper.floor(p_i46977_1_.rotationYaw * 256.0f / 360.0f);
        this.type = p_i46977_2_;
        this.data = p_i46977_3_;
        double lvt_4_1_ = 3.9;
        this.speedX = (int)(MathHelper.clamp(p_i46977_1_.motionX, -3.9, 3.9) * 8000.0);
        this.speedY = (int)(MathHelper.clamp(p_i46977_1_.motionY, -3.9, 3.9) * 8000.0);
        this.speedZ = (int)(MathHelper.clamp(p_i46977_1_.motionZ, -3.9, 3.9) * 8000.0);
    }

    public SPacketSpawnObject(Entity p_i46978_1_, int p_i46978_2_, int p_i46978_3_, BlockPos p_i46978_4_) {
        this(p_i46978_1_, p_i46978_2_, p_i46978_3_);
        this.x = p_i46978_4_.getX();
        this.y = p_i46978_4_.getY();
        this.z = p_i46978_4_.getZ();
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.uniqueId = p_readPacketData_1_.readUniqueId();
        this.type = p_readPacketData_1_.readByte();
        this.x = p_readPacketData_1_.readDouble();
        this.y = p_readPacketData_1_.readDouble();
        this.z = p_readPacketData_1_.readDouble();
        this.pitch = p_readPacketData_1_.readByte();
        this.yaw = p_readPacketData_1_.readByte();
        this.data = p_readPacketData_1_.readInt();
        this.speedX = p_readPacketData_1_.readShort();
        this.speedY = p_readPacketData_1_.readShort();
        this.speedZ = p_readPacketData_1_.readShort();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeUniqueId(this.uniqueId);
        p_writePacketData_1_.writeByte(this.type);
        p_writePacketData_1_.writeDouble(this.x);
        p_writePacketData_1_.writeDouble(this.y);
        p_writePacketData_1_.writeDouble(this.z);
        p_writePacketData_1_.writeByte(this.pitch);
        p_writePacketData_1_.writeByte(this.yaw);
        p_writePacketData_1_.writeInt(this.data);
        p_writePacketData_1_.writeShort(this.speedX);
        p_writePacketData_1_.writeShort(this.speedY);
        p_writePacketData_1_.writeShort(this.speedZ);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleSpawnObject(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityID() {
        return this.entityId;
    }

    public void setSpeedX(int p_setSpeedX_1_) {
        this.speedX = p_setSpeedX_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setSpeedY(int p_setSpeedY_1_) {
        this.speedY = p_setSpeedY_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.x;
    }

    public void setSpeedZ(int p_setSpeedZ_1_) {
        this.speedZ = p_setSpeedZ_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.y;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.z;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpeedX() {
        return this.speedX;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpeedY() {
        return this.speedY;
    }

    @SideOnly(value=Side.CLIENT)
    public int getSpeedZ() {
        return this.speedZ;
    }

    @SideOnly(value=Side.CLIENT)
    public int getPitch() {
        return this.pitch;
    }

    @SideOnly(value=Side.CLIENT)
    public int getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public int getType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public int getData() {
        return this.data;
    }

    @SideOnly(value=Side.CLIENT)
    public void setData(int p_setData_1_) {
        this.data = p_setData_1_;
    }
}

