/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.UUID;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketSpawnPainting
implements Packet<INetHandlerPlayClient> {
    private int entityID;
    private UUID uniqueId;
    private BlockPos position;
    private EnumFacing facing;
    private String title;

    public SPacketSpawnPainting() {
    }

    public SPacketSpawnPainting(EntityPainting p_i46972_1_) {
        this.entityID = p_i46972_1_.getEntityId();
        this.uniqueId = p_i46972_1_.getUniqueID();
        this.position = p_i46972_1_.getHangingPosition();
        this.facing = p_i46972_1_.facingDirection;
        this.title = p_i46972_1_.art.title;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityID = p_readPacketData_1_.readVarInt();
        this.uniqueId = p_readPacketData_1_.readUniqueId();
        this.title = p_readPacketData_1_.readString(EntityPainting.EnumArt.MAX_NAME_LENGTH);
        this.position = p_readPacketData_1_.readBlockPos();
        this.facing = EnumFacing.getHorizontal(p_readPacketData_1_.readUnsignedByte());
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityID);
        p_writePacketData_1_.writeUniqueId(this.uniqueId);
        p_writePacketData_1_.writeString(this.title);
        p_writePacketData_1_.writeBlockPos(this.position);
        p_writePacketData_1_.writeByte(this.facing.getHorizontalIndex());
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleSpawnPainting(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityID() {
        return this.entityID;
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getPosition() {
        return this.position;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumFacing getFacing() {
        return this.facing;
    }

    @SideOnly(value=Side.CLIENT)
    public String getTitle() {
        return this.title;
    }
}

