/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketSpawnPlayer
implements Packet<INetHandlerPlayClient> {
    private int entityId;
    private UUID uniqueId;
    private double x;
    private double y;
    private double z;
    private byte yaw;
    private byte pitch;
    private EntityDataManager watcher;
    private List<EntityDataManager.DataEntry<?>> dataManagerEntries;

    public SPacketSpawnPlayer() {
    }

    public SPacketSpawnPlayer(EntityPlayer p_i46971_1_) {
        this.entityId = p_i46971_1_.getEntityId();
        this.uniqueId = p_i46971_1_.getGameProfile().getId();
        this.x = p_i46971_1_.posX;
        this.y = p_i46971_1_.posY;
        this.z = p_i46971_1_.posZ;
        this.yaw = (byte)(p_i46971_1_.rotationYaw * 256.0f / 360.0f);
        this.pitch = (byte)(p_i46971_1_.rotationPitch * 256.0f / 360.0f);
        this.watcher = p_i46971_1_.getDataManager();
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.entityId = p_readPacketData_1_.readVarInt();
        this.uniqueId = p_readPacketData_1_.readUniqueId();
        this.x = p_readPacketData_1_.readDouble();
        this.y = p_readPacketData_1_.readDouble();
        this.z = p_readPacketData_1_.readDouble();
        this.yaw = p_readPacketData_1_.readByte();
        this.pitch = p_readPacketData_1_.readByte();
        this.dataManagerEntries = EntityDataManager.readEntries(p_readPacketData_1_);
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.entityId);
        p_writePacketData_1_.writeUniqueId(this.uniqueId);
        p_writePacketData_1_.writeDouble(this.x);
        p_writePacketData_1_.writeDouble(this.y);
        p_writePacketData_1_.writeDouble(this.z);
        p_writePacketData_1_.writeByte(this.yaw);
        p_writePacketData_1_.writeByte(this.pitch);
        this.watcher.writeEntries(p_writePacketData_1_);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleSpawnPlayer(this);
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public List<EntityDataManager.DataEntry<?>> getDataManagerEntries() {
        return this.dataManagerEntries;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEntityID() {
        return this.entityId;
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @SideOnly(value=Side.CLIENT)
    public double getX() {
        return this.x;
    }

    @SideOnly(value=Side.CLIENT)
    public double getY() {
        return this.y;
    }

    @SideOnly(value=Side.CLIENT)
    public double getZ() {
        return this.z;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getYaw() {
        return this.yaw;
    }

    @SideOnly(value=Side.CLIENT)
    public byte getPitch() {
        return this.pitch;
    }
}

