/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketStatistics
implements Packet<INetHandlerPlayClient> {
    private Map<StatBase, Integer> statisticMap;

    public SPacketStatistics() {
    }

    public SPacketStatistics(Map<StatBase, Integer> p_i46969_1_) {
        this.statisticMap = p_i46969_1_;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleStatistics(this);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        int lvt_2_1_ = p_readPacketData_1_.readVarInt();
        this.statisticMap = Maps.newHashMap();
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            StatBase lvt_4_1_ = StatList.getOneShotStat(p_readPacketData_1_.readString(Short.MAX_VALUE));
            int lvt_5_1_ = p_readPacketData_1_.readVarInt();
            if (lvt_4_1_ == null) continue;
            this.statisticMap.put(lvt_4_1_, lvt_5_1_);
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeVarInt(this.statisticMap.size());
        for (Map.Entry<StatBase, Integer> lvt_3_1_ : this.statisticMap.entrySet()) {
            p_writePacketData_1_.writeString(lvt_3_1_.getKey().statId);
            p_writePacketData_1_.writeVarInt(lvt_3_1_.getValue());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Map<StatBase, Integer> getStatisticMap() {
        return this.statisticMap;
    }
}

