/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketTeams
implements Packet<INetHandlerPlayClient> {
    private String name = "";
    private String displayName = "";
    private String prefix = "";
    private String suffix = "";
    private String nameTagVisibility;
    private String collisionRule;
    private int color;
    private final Collection<String> players;
    private int action;
    private int friendlyFlags;

    public SPacketTeams() {
        this.nameTagVisibility = Team.EnumVisible.ALWAYS.internalName;
        this.collisionRule = Team.CollisionRule.ALWAYS.name;
        this.color = -1;
        this.players = Lists.newArrayList();
    }

    public SPacketTeams(ScorePlayerTeam p_i46907_1_, int p_i46907_2_) {
        this.nameTagVisibility = Team.EnumVisible.ALWAYS.internalName;
        this.collisionRule = Team.CollisionRule.ALWAYS.name;
        this.color = -1;
        this.players = Lists.newArrayList();
        this.name = p_i46907_1_.getRegisteredName();
        this.action = p_i46907_2_;
        if (p_i46907_2_ == 0 || p_i46907_2_ == 2) {
            this.displayName = p_i46907_1_.getTeamName();
            this.prefix = p_i46907_1_.getColorPrefix();
            this.suffix = p_i46907_1_.getColorSuffix();
            this.friendlyFlags = p_i46907_1_.getFriendlyFlags();
            this.nameTagVisibility = p_i46907_1_.getNameTagVisibility().internalName;
            this.collisionRule = p_i46907_1_.getCollisionRule().name;
            this.color = p_i46907_1_.getChatFormat().getColorIndex();
        }
        if (p_i46907_2_ == 0) {
            this.players.addAll(p_i46907_1_.getMembershipCollection());
        }
    }

    public SPacketTeams(ScorePlayerTeam p_i46908_1_, Collection<String> p_i46908_2_, int p_i46908_3_) {
        this.nameTagVisibility = Team.EnumVisible.ALWAYS.internalName;
        this.collisionRule = Team.CollisionRule.ALWAYS.name;
        this.color = -1;
        this.players = Lists.newArrayList();
        if (p_i46908_3_ != 3 && p_i46908_3_ != 4) {
            throw new IllegalArgumentException("Method must be join or leave for player constructor");
        }
        if (p_i46908_2_ == null || p_i46908_2_.isEmpty()) {
            throw new IllegalArgumentException("Players cannot be null/empty");
        }
        this.action = p_i46908_3_;
        this.name = p_i46908_1_.getRegisteredName();
        this.players.addAll(p_i46908_2_);
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.name = p_readPacketData_1_.readString(16);
        this.action = p_readPacketData_1_.readByte();
        if (this.action == 0 || this.action == 2) {
            this.displayName = p_readPacketData_1_.readString(32);
            this.prefix = p_readPacketData_1_.readString(16);
            this.suffix = p_readPacketData_1_.readString(16);
            this.friendlyFlags = p_readPacketData_1_.readByte();
            this.nameTagVisibility = p_readPacketData_1_.readString(32);
            this.collisionRule = p_readPacketData_1_.readString(32);
            this.color = p_readPacketData_1_.readByte();
        }
        if (this.action == 0 || this.action == 3 || this.action == 4) {
            int lvt_2_1_ = p_readPacketData_1_.readVarInt();
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
                this.players.add(p_readPacketData_1_.readString(40));
            }
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.name);
        p_writePacketData_1_.writeByte(this.action);
        if (this.action == 0 || this.action == 2) {
            p_writePacketData_1_.writeString(this.displayName);
            p_writePacketData_1_.writeString(this.prefix);
            p_writePacketData_1_.writeString(this.suffix);
            p_writePacketData_1_.writeByte(this.friendlyFlags);
            p_writePacketData_1_.writeString(this.nameTagVisibility);
            p_writePacketData_1_.writeString(this.collisionRule);
            p_writePacketData_1_.writeByte(this.color);
        }
        if (this.action == 0 || this.action == 3 || this.action == 4) {
            p_writePacketData_1_.writeVarInt(this.players.size());
            for (String lvt_3_1_ : this.players) {
                p_writePacketData_1_.writeString(lvt_3_1_);
            }
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleTeams(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDisplayName() {
        return this.displayName;
    }

    @SideOnly(value=Side.CLIENT)
    public String getPrefix() {
        return this.prefix;
    }

    @SideOnly(value=Side.CLIENT)
    public String getSuffix() {
        return this.suffix;
    }

    @SideOnly(value=Side.CLIENT)
    public Collection<String> getPlayers() {
        return this.players;
    }

    @SideOnly(value=Side.CLIENT)
    public int getAction() {
        return this.action;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFriendlyFlags() {
        return this.friendlyFlags;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public String getNameTagVisibility() {
        return this.nameTagVisibility;
    }

    @SideOnly(value=Side.CLIENT)
    public String getCollisionRule() {
        return this.collisionRule;
    }
}

