/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketTimeUpdate
implements Packet<INetHandlerPlayClient> {
    private long totalWorldTime;
    private long worldTime;

    public SPacketTimeUpdate() {
    }

    public SPacketTimeUpdate(long p_i46902_1_, long p_i46902_3_, boolean p_i46902_5_) {
        this.totalWorldTime = p_i46902_1_;
        this.worldTime = p_i46902_3_;
        if (!p_i46902_5_) {
            this.worldTime = -this.worldTime;
            if (this.worldTime == 0L) {
                this.worldTime = -1L;
            }
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.totalWorldTime = p_readPacketData_1_.readLong();
        this.worldTime = p_readPacketData_1_.readLong();
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeLong(this.totalWorldTime);
        p_writePacketData_1_.writeLong(this.worldTime);
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleTimeUpdate(this);
    }

    @SideOnly(value=Side.CLIENT)
    public long getTotalWorldTime() {
        return this.totalWorldTime;
    }

    @SideOnly(value=Side.CLIENT)
    public long getWorldTime() {
        return this.worldTime;
    }
}

