/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.Locale;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketTitle
implements Packet<INetHandlerPlayClient> {
    private Type type;
    private ITextComponent message;
    private int fadeInTime;
    private int displayTime;
    private int fadeOutTime;

    public SPacketTitle() {
    }

    public SPacketTitle(Type p_i46899_1_, ITextComponent p_i46899_2_) {
        this(p_i46899_1_, p_i46899_2_, -1, -1, -1);
    }

    public SPacketTitle(int p_i46900_1_, int p_i46900_2_, int p_i46900_3_) {
        this(Type.TIMES, null, p_i46900_1_, p_i46900_2_, p_i46900_3_);
    }

    public SPacketTitle(Type p_i46901_1_, ITextComponent p_i46901_2_, int p_i46901_3_, int p_i46901_4_, int p_i46901_5_) {
        this.type = p_i46901_1_;
        this.message = p_i46901_2_;
        this.fadeInTime = p_i46901_3_;
        this.displayTime = p_i46901_4_;
        this.fadeOutTime = p_i46901_5_;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.type = p_readPacketData_1_.readEnumValue(Type.class);
        if (this.type == Type.TITLE || this.type == Type.SUBTITLE || this.type == Type.ACTIONBAR) {
            this.message = p_readPacketData_1_.readTextComponent();
        }
        if (this.type == Type.TIMES) {
            this.fadeInTime = p_readPacketData_1_.readInt();
            this.displayTime = p_readPacketData_1_.readInt();
            this.fadeOutTime = p_readPacketData_1_.readInt();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeEnumValue(this.type);
        if (this.type == Type.TITLE || this.type == Type.SUBTITLE || this.type == Type.ACTIONBAR) {
            p_writePacketData_1_.writeTextComponent(this.message);
        }
        if (this.type == Type.TIMES) {
            p_writePacketData_1_.writeInt(this.fadeInTime);
            p_writePacketData_1_.writeInt(this.displayTime);
            p_writePacketData_1_.writeInt(this.fadeOutTime);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleTitle(this);
    }

    @SideOnly(value=Side.CLIENT)
    public Type getType() {
        return this.type;
    }

    @SideOnly(value=Side.CLIENT)
    public ITextComponent getMessage() {
        return this.message;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFadeInTime() {
        return this.fadeInTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getDisplayTime() {
        return this.displayTime;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFadeOutTime() {
        return this.fadeOutTime;
    }

    public static enum Type {
        TITLE,
        SUBTITLE,
        ACTIONBAR,
        TIMES,
        CLEAR,
        RESET;


        public static Type byName(String p_byName_0_) {
            for (Type lvt_4_1_ : Type.values()) {
                if (!lvt_4_1_.name().equalsIgnoreCase(p_byName_0_)) continue;
                return lvt_4_1_;
            }
            return TITLE;
        }

        public static String[] getNames() {
            String[] lvt_0_1_ = new String[Type.values().length];
            int lvt_1_1_ = 0;
            for (Type lvt_5_1_ : Type.values()) {
                lvt_0_1_[lvt_1_1_++] = lvt_5_1_.name().toLowerCase(Locale.ROOT);
            }
            return lvt_0_1_;
        }
    }
}

