/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.UUID;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketUpdateBossInfo
implements Packet<INetHandlerPlayClient> {
    private UUID uniqueId;
    private Operation operation;
    private ITextComponent name;
    private float percent;
    private BossInfo.Color color;
    private BossInfo.Overlay overlay;
    private boolean darkenSky;
    private boolean playEndBossMusic;
    private boolean createFog;

    public SPacketUpdateBossInfo() {
    }

    public SPacketUpdateBossInfo(Operation p_i46964_1_, BossInfo p_i46964_2_) {
        this.operation = p_i46964_1_;
        this.uniqueId = p_i46964_2_.getUniqueId();
        this.name = p_i46964_2_.getName();
        this.percent = p_i46964_2_.getPercent();
        this.color = p_i46964_2_.getColor();
        this.overlay = p_i46964_2_.getOverlay();
        this.darkenSky = p_i46964_2_.shouldDarkenSky();
        this.playEndBossMusic = p_i46964_2_.shouldPlayEndBossMusic();
        this.createFog = p_i46964_2_.shouldCreateFog();
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.uniqueId = p_readPacketData_1_.readUniqueId();
        this.operation = p_readPacketData_1_.readEnumValue(Operation.class);
        switch (this.operation) {
            case ADD: {
                this.name = p_readPacketData_1_.readTextComponent();
                this.percent = p_readPacketData_1_.readFloat();
                this.color = p_readPacketData_1_.readEnumValue(BossInfo.Color.class);
                this.overlay = p_readPacketData_1_.readEnumValue(BossInfo.Overlay.class);
                this.setFlags(p_readPacketData_1_.readUnsignedByte());
                break;
            }
            case REMOVE: {
                break;
            }
            case UPDATE_PCT: {
                this.percent = p_readPacketData_1_.readFloat();
                break;
            }
            case UPDATE_NAME: {
                this.name = p_readPacketData_1_.readTextComponent();
                break;
            }
            case UPDATE_STYLE: {
                this.color = p_readPacketData_1_.readEnumValue(BossInfo.Color.class);
                this.overlay = p_readPacketData_1_.readEnumValue(BossInfo.Overlay.class);
                break;
            }
            case UPDATE_PROPERTIES: {
                this.setFlags(p_readPacketData_1_.readUnsignedByte());
            }
        }
    }

    private void setFlags(int p_setFlags_1_) {
        this.darkenSky = (p_setFlags_1_ & 1) > 0;
        this.playEndBossMusic = (p_setFlags_1_ & 2) > 0;
        this.createFog = (p_setFlags_1_ & 2) > 0;
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeUniqueId(this.uniqueId);
        p_writePacketData_1_.writeEnumValue(this.operation);
        switch (this.operation) {
            case ADD: {
                p_writePacketData_1_.writeTextComponent(this.name);
                p_writePacketData_1_.writeFloat(this.percent);
                p_writePacketData_1_.writeEnumValue(this.color);
                p_writePacketData_1_.writeEnumValue(this.overlay);
                p_writePacketData_1_.writeByte(this.getFlags());
                break;
            }
            case REMOVE: {
                break;
            }
            case UPDATE_PCT: {
                p_writePacketData_1_.writeFloat(this.percent);
                break;
            }
            case UPDATE_NAME: {
                p_writePacketData_1_.writeTextComponent(this.name);
                break;
            }
            case UPDATE_STYLE: {
                p_writePacketData_1_.writeEnumValue(this.color);
                p_writePacketData_1_.writeEnumValue(this.overlay);
                break;
            }
            case UPDATE_PROPERTIES: {
                p_writePacketData_1_.writeByte(this.getFlags());
            }
        }
    }

    private int getFlags() {
        int lvt_1_1_ = 0;
        if (this.darkenSky) {
            lvt_1_1_ |= 1;
        }
        if (this.playEndBossMusic) {
            lvt_1_1_ |= 2;
        }
        if (this.createFog) {
            lvt_1_1_ |= 2;
        }
        return lvt_1_1_;
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleUpdateBossInfo(this);
    }

    @SideOnly(value=Side.CLIENT)
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @SideOnly(value=Side.CLIENT)
    public Operation getOperation() {
        return this.operation;
    }

    @SideOnly(value=Side.CLIENT)
    public ITextComponent getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public float getPercent() {
        return this.percent;
    }

    @SideOnly(value=Side.CLIENT)
    public BossInfo.Color getColor() {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public BossInfo.Overlay getOverlay() {
        return this.overlay;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldDarkenSky() {
        return this.darkenSky;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldPlayEndBossMusic() {
        return this.playEndBossMusic;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldCreateFog() {
        return this.createFog;
    }

    public static enum Operation {
        ADD,
        REMOVE,
        UPDATE_PCT,
        UPDATE_NAME,
        UPDATE_STYLE,
        UPDATE_PROPERTIES;

    }
}

