/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketUpdateScore
implements Packet<INetHandlerPlayClient> {
    private String name = "";
    private String objective = "";
    private int value;
    private Action action;

    public SPacketUpdateScore() {
    }

    public SPacketUpdateScore(Score p_i46904_1_) {
        this.name = p_i46904_1_.getPlayerName();
        this.objective = p_i46904_1_.getObjective().getName();
        this.value = p_i46904_1_.getScorePoints();
        this.action = Action.CHANGE;
    }

    public SPacketUpdateScore(String p_i46905_1_) {
        this.name = p_i46905_1_;
        this.objective = "";
        this.value = 0;
        this.action = Action.REMOVE;
    }

    public SPacketUpdateScore(String p_i46906_1_, ScoreObjective p_i46906_2_) {
        this.name = p_i46906_1_;
        this.objective = p_i46906_2_.getName();
        this.value = 0;
        this.action = Action.REMOVE;
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.name = p_readPacketData_1_.readString(40);
        this.action = p_readPacketData_1_.readEnumValue(Action.class);
        this.objective = p_readPacketData_1_.readString(16);
        if (this.action != Action.REMOVE) {
            this.value = p_readPacketData_1_.readVarInt();
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeString(this.name);
        p_writePacketData_1_.writeEnumValue(this.action);
        p_writePacketData_1_.writeString(this.objective);
        if (this.action != Action.REMOVE) {
            p_writePacketData_1_.writeVarInt(this.value);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleUpdateScore(this);
    }

    @SideOnly(value=Side.CLIENT)
    public String getPlayerName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public String getObjectiveName() {
        return this.objective;
    }

    @SideOnly(value=Side.CLIENT)
    public int getScoreValue() {
        return this.value;
    }

    @SideOnly(value=Side.CLIENT)
    public Action getScoreAction() {
        return this.action;
    }

    public static enum Action {
        CHANGE,
        REMOVE;

    }
}

