/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketWindowItems
implements Packet<INetHandlerPlayClient> {
    private int windowId;
    private List<ItemStack> itemStacks;

    public SPacketWindowItems() {
    }

    public SPacketWindowItems(int p_i47317_1_, NonNullList<ItemStack> p_i47317_2_) {
        this.windowId = p_i47317_1_;
        this.itemStacks = NonNullList.withSize(p_i47317_2_.size(), ItemStack.EMPTY);
        for (int lvt_3_1_ = 0; lvt_3_1_ < this.itemStacks.size(); ++lvt_3_1_) {
            ItemStack lvt_4_1_ = p_i47317_2_.get(lvt_3_1_);
            if (lvt_4_1_.isEmpty()) continue;
            this.itemStacks.set(lvt_3_1_, lvt_4_1_.copy());
        }
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.windowId = p_readPacketData_1_.readUnsignedByte();
        int lvt_2_1_ = p_readPacketData_1_.readShort();
        this.itemStacks = NonNullList.withSize(lvt_2_1_, ItemStack.EMPTY);
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_; ++lvt_3_1_) {
            this.itemStacks.set(lvt_3_1_, p_readPacketData_1_.readItemStack());
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeByte(this.windowId);
        p_writePacketData_1_.writeShort(this.itemStacks.size());
        for (ItemStack lvt_3_1_ : this.itemStacks) {
            p_writePacketData_1_.writeItemStack(lvt_3_1_);
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleWindowItems(this);
    }

    @SideOnly(value=Side.CLIENT)
    public int getWindowId() {
        return this.windowId;
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemStack> getItemStacks() {
        return this.itemStacks;
    }
}

