/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import java.io.IOException;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.world.border.WorldBorder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SPacketWorldBorder
implements Packet<INetHandlerPlayClient> {
    private Action action;
    private int size;
    private double centerX;
    private double centerZ;
    private double targetSize;
    private double diameter;
    private long timeUntilTarget;
    private int warningTime;
    private int warningDistance;

    public SPacketWorldBorder() {
    }

    public SPacketWorldBorder(WorldBorder p_i46921_1_, Action p_i46921_2_) {
        this.action = p_i46921_2_;
        this.centerX = p_i46921_1_.getCenterX();
        this.centerZ = p_i46921_1_.getCenterZ();
        this.diameter = p_i46921_1_.getDiameter();
        this.targetSize = p_i46921_1_.getTargetSize();
        this.timeUntilTarget = p_i46921_1_.getTimeUntilTarget();
        this.size = p_i46921_1_.getSize();
        this.warningDistance = p_i46921_1_.getWarningDistance();
        this.warningTime = p_i46921_1_.getWarningTime();
    }

    @Override
    public void readPacketData(PacketBuffer p_readPacketData_1_) throws IOException {
        this.action = p_readPacketData_1_.readEnumValue(Action.class);
        switch (this.action) {
            case SET_SIZE: {
                this.targetSize = p_readPacketData_1_.readDouble();
                break;
            }
            case LERP_SIZE: {
                this.diameter = p_readPacketData_1_.readDouble();
                this.targetSize = p_readPacketData_1_.readDouble();
                this.timeUntilTarget = p_readPacketData_1_.readVarLong();
                break;
            }
            case SET_CENTER: {
                this.centerX = p_readPacketData_1_.readDouble();
                this.centerZ = p_readPacketData_1_.readDouble();
                break;
            }
            case SET_WARNING_BLOCKS: {
                this.warningDistance = p_readPacketData_1_.readVarInt();
                break;
            }
            case SET_WARNING_TIME: {
                this.warningTime = p_readPacketData_1_.readVarInt();
                break;
            }
            case INITIALIZE: {
                this.centerX = p_readPacketData_1_.readDouble();
                this.centerZ = p_readPacketData_1_.readDouble();
                this.diameter = p_readPacketData_1_.readDouble();
                this.targetSize = p_readPacketData_1_.readDouble();
                this.timeUntilTarget = p_readPacketData_1_.readVarLong();
                this.size = p_readPacketData_1_.readVarInt();
                this.warningDistance = p_readPacketData_1_.readVarInt();
                this.warningTime = p_readPacketData_1_.readVarInt();
            }
        }
    }

    @Override
    public void writePacketData(PacketBuffer p_writePacketData_1_) throws IOException {
        p_writePacketData_1_.writeEnumValue(this.action);
        switch (this.action) {
            case SET_SIZE: {
                p_writePacketData_1_.writeDouble(this.targetSize);
                break;
            }
            case LERP_SIZE: {
                p_writePacketData_1_.writeDouble(this.diameter);
                p_writePacketData_1_.writeDouble(this.targetSize);
                p_writePacketData_1_.writeVarLong(this.timeUntilTarget);
                break;
            }
            case SET_CENTER: {
                p_writePacketData_1_.writeDouble(this.centerX);
                p_writePacketData_1_.writeDouble(this.centerZ);
                break;
            }
            case SET_WARNING_TIME: {
                p_writePacketData_1_.writeVarInt(this.warningTime);
                break;
            }
            case SET_WARNING_BLOCKS: {
                p_writePacketData_1_.writeVarInt(this.warningDistance);
                break;
            }
            case INITIALIZE: {
                p_writePacketData_1_.writeDouble(this.centerX);
                p_writePacketData_1_.writeDouble(this.centerZ);
                p_writePacketData_1_.writeDouble(this.diameter);
                p_writePacketData_1_.writeDouble(this.targetSize);
                p_writePacketData_1_.writeVarLong(this.timeUntilTarget);
                p_writePacketData_1_.writeVarInt(this.size);
                p_writePacketData_1_.writeVarInt(this.warningDistance);
                p_writePacketData_1_.writeVarInt(this.warningTime);
            }
        }
    }

    @Override
    public void processPacket(INetHandlerPlayClient p_processPacket_1_) {
        p_processPacket_1_.handleWorldBorder(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void apply(WorldBorder p_apply_1_) {
        switch (this.action) {
            case SET_SIZE: {
                p_apply_1_.setTransition(this.targetSize);
                break;
            }
            case LERP_SIZE: {
                p_apply_1_.setTransition(this.diameter, this.targetSize, this.timeUntilTarget);
                break;
            }
            case SET_CENTER: {
                p_apply_1_.setCenter(this.centerX, this.centerZ);
                break;
            }
            case INITIALIZE: {
                p_apply_1_.setCenter(this.centerX, this.centerZ);
                if (this.timeUntilTarget > 0L) {
                    p_apply_1_.setTransition(this.diameter, this.targetSize, this.timeUntilTarget);
                } else {
                    p_apply_1_.setTransition(this.targetSize);
                }
                p_apply_1_.setSize(this.size);
                p_apply_1_.setWarningDistance(this.warningDistance);
                p_apply_1_.setWarningTime(this.warningTime);
                break;
            }
            case SET_WARNING_TIME: {
                p_apply_1_.setWarningTime(this.warningTime);
                break;
            }
            case SET_WARNING_BLOCKS: {
                p_apply_1_.setWarningDistance(this.warningDistance);
            }
        }
    }

    public static enum Action {
        SET_SIZE,
        LERP_SIZE,
        SET_CENTER,
        INITIALIZE,
        SET_WARNING_TIME,
        SET_WARNING_BLOCKS;

    }
}

