/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.rcon.IServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public abstract class RConThreadBase
implements Runnable {
    private static final AtomicInteger THREAD_ID = new AtomicInteger(0);
    protected boolean running;
    protected IServer server;
    protected final String threadName;
    protected Thread rconThread;
    protected int maxStopWait = 5;
    protected List<DatagramSocket> socketList = Lists.newArrayList();
    protected List<ServerSocket> serverSocketList = Lists.newArrayList();

    protected RConThreadBase(IServer p_i45300_1_, String p_i45300_2_) {
        this.server = p_i45300_1_;
        this.threadName = p_i45300_2_;
        if (this.server.isDebuggingEnabled()) {
            this.logWarning("Debugging is enabled, performance maybe reduced!");
        }
    }

    public synchronized void startThread() {
        this.rconThread = new Thread((Runnable)this, this.threadName + " #" + THREAD_ID.incrementAndGet());
        this.rconThread.start();
        this.running = true;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected void logDebug(String p_logDebug_1_) {
        this.server.logDebug(p_logDebug_1_);
    }

    protected void logInfo(String p_logInfo_1_) {
        this.server.logInfo(p_logInfo_1_);
    }

    protected void logWarning(String p_logWarning_1_) {
        this.server.logWarning(p_logWarning_1_);
    }

    protected void logSevere(String p_logSevere_1_) {
        this.server.logSevere(p_logSevere_1_);
    }

    protected int getNumberOfPlayers() {
        return this.server.getCurrentPlayerCount();
    }

    protected void registerSocket(DatagramSocket p_registerSocket_1_) {
        this.logDebug("registerSocket: " + p_registerSocket_1_);
        this.socketList.add(p_registerSocket_1_);
    }

    protected boolean closeSocket(DatagramSocket p_closeSocket_1_, boolean p_closeSocket_2_) {
        this.logDebug("closeSocket: " + p_closeSocket_1_);
        if (null == p_closeSocket_1_) {
            return false;
        }
        boolean lvt_3_1_ = false;
        if (!p_closeSocket_1_.isClosed()) {
            p_closeSocket_1_.close();
            lvt_3_1_ = true;
        }
        if (p_closeSocket_2_) {
            this.socketList.remove(p_closeSocket_1_);
        }
        return lvt_3_1_;
    }

    protected boolean closeServerSocket(ServerSocket p_closeServerSocket_1_) {
        return this.closeServerSocket_do(p_closeServerSocket_1_, true);
    }

    protected boolean closeServerSocket_do(ServerSocket p_closeServerSocket_do_1_, boolean p_closeServerSocket_do_2_) {
        this.logDebug("closeSocket: " + p_closeServerSocket_do_1_);
        if (null == p_closeServerSocket_do_1_) {
            return false;
        }
        boolean lvt_3_1_ = false;
        try {
            if (!p_closeServerSocket_do_1_.isClosed()) {
                p_closeServerSocket_do_1_.close();
                lvt_3_1_ = true;
            }
        }
        catch (IOException lvt_4_1_) {
            this.logWarning("IO: " + lvt_4_1_.getMessage());
        }
        if (p_closeServerSocket_do_2_) {
            this.serverSocketList.remove(p_closeServerSocket_do_1_);
        }
        return lvt_3_1_;
    }

    protected void closeAllSockets() {
        this.closeAllSockets_do(false);
    }

    protected void closeAllSockets_do(boolean p_closeAllSockets_do_1_) {
        int lvt_2_1_ = 0;
        for (DatagramSocket lvt_4_1_ : this.socketList) {
            if (!this.closeSocket(lvt_4_1_, false)) continue;
            ++lvt_2_1_;
        }
        this.socketList.clear();
        for (ServerSocket lvt_4_2_ : this.serverSocketList) {
            if (!this.closeServerSocket_do(lvt_4_2_, false)) continue;
            ++lvt_2_1_;
        }
        this.serverSocketList.clear();
        if (p_closeAllSockets_do_1_ && 0 < lvt_2_1_) {
            this.logWarning("Force closed " + lvt_2_1_ + " sockets");
        }
    }
}

