/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThreadBase;
import net.minecraft.network.rcon.RConUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SideOnly(value=Side.SERVER)
public class RConThreadClient
extends RConThreadBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private boolean loggedIn;
    private Socket clientSocket;
    private final byte[] buffer = new byte[1460];
    private final String rconPassword;

    RConThreadClient(IServer p_i1537_1_, Socket p_i1537_2_) {
        super(p_i1537_1_, "RCON Client");
        this.clientSocket = p_i1537_2_;
        try {
            this.clientSocket.setSoTimeout(0);
        }
        catch (Exception lvt_3_1_) {
            this.running = false;
        }
        this.rconPassword = p_i1537_1_.getStringProperty("rcon.password", "");
        this.logInfo("Rcon connection from: " + p_i1537_2_.getInetAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                BufferedInputStream lvt_1_1_ = new BufferedInputStream(this.clientSocket.getInputStream());
                int lvt_2_1_ = lvt_1_1_.read(this.buffer, 0, 1460);
                if (10 > lvt_2_1_) {
                    return;
                }
                int lvt_3_1_ = 0;
                int lvt_4_1_ = RConUtils.getBytesAsLEInt(this.buffer, 0, lvt_2_1_);
                if (lvt_4_1_ != lvt_2_1_ - 4) {
                    return;
                }
                int lvt_5_1_ = RConUtils.getBytesAsLEInt(this.buffer, lvt_3_1_ += 4, lvt_2_1_);
                int lvt_6_1_ = RConUtils.getRemainingBytesAsLEInt(this.buffer, lvt_3_1_ += 4);
                lvt_3_1_ += 4;
                switch (lvt_6_1_) {
                    case 3: {
                        String lvt_7_1_ = RConUtils.getBytesAsString(this.buffer, lvt_3_1_, lvt_2_1_);
                        lvt_3_1_ += lvt_7_1_.length();
                        if (!lvt_7_1_.isEmpty() && lvt_7_1_.equals(this.rconPassword)) {
                            this.loggedIn = true;
                            this.sendResponse(lvt_5_1_, 2, "");
                            break;
                        }
                        this.loggedIn = false;
                        this.sendLoginFailedResponse();
                        break;
                    }
                    case 2: {
                        if (this.loggedIn) {
                            String lvt_8_1_ = RConUtils.getBytesAsString(this.buffer, lvt_3_1_, lvt_2_1_);
                            try {
                                this.sendMultipacketResponse(lvt_5_1_, this.server.handleRConCommand(lvt_8_1_));
                            }
                            catch (Exception lvt_9_1_) {
                                this.sendMultipacketResponse(lvt_5_1_, "Error executing: " + lvt_8_1_ + " (" + lvt_9_1_.getMessage() + ")");
                            }
                            break;
                        }
                        this.sendLoginFailedResponse();
                        break;
                    }
                    default: {
                        this.sendMultipacketResponse(lvt_5_1_, String.format("Unknown request %s", Integer.toHexString(lvt_6_1_)));
                    }
                }
            }
        }
        catch (SocketTimeoutException lvt_1_1_) {
        }
        catch (IOException lvt_1_1_) {
        }
        catch (Exception lvt_1_2_) {
            LOGGER.error("Exception whilst parsing RCON input", (Throwable)lvt_1_2_);
        }
        finally {
            this.closeSocket();
        }
    }

    private void sendResponse(int p_sendResponse_1_, int p_sendResponse_2_, String p_sendResponse_3_) throws IOException {
        ByteArrayOutputStream lvt_4_1_ = new ByteArrayOutputStream(1248);
        DataOutputStream lvt_5_1_ = new DataOutputStream(lvt_4_1_);
        byte[] lvt_6_1_ = p_sendResponse_3_.getBytes("UTF-8");
        lvt_5_1_.writeInt(Integer.reverseBytes(lvt_6_1_.length + 10));
        lvt_5_1_.writeInt(Integer.reverseBytes(p_sendResponse_1_));
        lvt_5_1_.writeInt(Integer.reverseBytes(p_sendResponse_2_));
        lvt_5_1_.write(lvt_6_1_);
        lvt_5_1_.write(0);
        lvt_5_1_.write(0);
        this.clientSocket.getOutputStream().write(lvt_4_1_.toByteArray());
    }

    private void sendLoginFailedResponse() throws IOException {
        this.sendResponse(-1, 2, "");
    }

    private void sendMultipacketResponse(int p_sendMultipacketResponse_1_, String p_sendMultipacketResponse_2_) throws IOException {
        int lvt_4_1_;
        int lvt_3_1_ = p_sendMultipacketResponse_2_.length();
        do {
            lvt_4_1_ = 4096 <= lvt_3_1_ ? 4096 : lvt_3_1_;
            this.sendResponse(p_sendMultipacketResponse_1_, 0, p_sendMultipacketResponse_2_.substring(0, lvt_4_1_));
        } while (0 != (lvt_3_1_ = (p_sendMultipacketResponse_2_ = p_sendMultipacketResponse_2_.substring(lvt_4_1_)).length()));
    }

    private void closeSocket() {
        if (null == this.clientSocket) {
            return;
        }
        try {
            this.clientSocket.close();
        }
        catch (IOException lvt_1_1_) {
            this.logWarning("IO: " + lvt_1_1_.getMessage());
        }
        this.clientSocket = null;
    }
}

