/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.rcon;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.network.rcon.IServer;
import net.minecraft.network.rcon.RConThreadBase;
import net.minecraft.network.rcon.RConThreadClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.SERVER)
public class RConThreadMain
extends RConThreadBase {
    private int rconPort;
    private final int serverPort;
    private String hostname;
    private ServerSocket serverSocket;
    private final String rconPassword;
    private Map<SocketAddress, RConThreadClient> clientThreads;

    public RConThreadMain(IServer p_i1538_1_) {
        super(p_i1538_1_, "RCON Listener");
        this.rconPort = p_i1538_1_.getIntProperty("rcon.port", 0);
        this.rconPassword = p_i1538_1_.getStringProperty("rcon.password", "");
        this.hostname = p_i1538_1_.getHostname();
        this.serverPort = p_i1538_1_.getPort();
        if (0 == this.rconPort) {
            this.rconPort = this.serverPort + 10;
            this.logInfo("Setting default rcon port to " + this.rconPort);
            p_i1538_1_.setProperty("rcon.port", this.rconPort);
            if (this.rconPassword.isEmpty()) {
                p_i1538_1_.setProperty("rcon.password", "");
            }
            p_i1538_1_.saveProperties();
        }
        if (this.hostname.isEmpty()) {
            this.hostname = "0.0.0.0";
        }
        this.initClientThreadList();
        this.serverSocket = null;
    }

    private void initClientThreadList() {
        this.clientThreads = Maps.newHashMap();
    }

    private void cleanClientThreadsMap() {
        Iterator<Map.Entry<SocketAddress, RConThreadClient>> lvt_1_1_ = this.clientThreads.entrySet().iterator();
        while (lvt_1_1_.hasNext()) {
            Map.Entry<SocketAddress, RConThreadClient> lvt_2_1_ = lvt_1_1_.next();
            if (lvt_2_1_.getValue().isRunning()) continue;
            lvt_1_1_.remove();
        }
    }

    @Override
    public void run() {
        this.logInfo("RCON running on " + this.hostname + ":" + this.rconPort);
        try {
            while (this.running) {
                try {
                    Socket lvt_1_1_ = this.serverSocket.accept();
                    lvt_1_1_.setSoTimeout(500);
                    RConThreadClient lvt_2_1_ = new RConThreadClient(this.server, lvt_1_1_);
                    lvt_2_1_.startThread();
                    this.clientThreads.put(lvt_1_1_.getRemoteSocketAddress(), lvt_2_1_);
                    this.cleanClientThreadsMap();
                }
                catch (SocketTimeoutException lvt_1_2_) {
                    this.cleanClientThreadsMap();
                }
                catch (IOException lvt_1_3_) {
                    if (!this.running) continue;
                    this.logInfo("IO: " + lvt_1_3_.getMessage());
                }
            }
        }
        finally {
            this.closeServerSocket(this.serverSocket);
        }
    }

    @Override
    public void startThread() {
        if (this.rconPassword.isEmpty()) {
            this.logWarning("No rcon password set in '" + this.server.getSettingsFilename() + "', rcon disabled!");
            return;
        }
        if (0 >= this.rconPort || 65535 < this.rconPort) {
            this.logWarning("Invalid rcon port " + this.rconPort + " found in '" + this.server.getSettingsFilename() + "', rcon disabled!");
            return;
        }
        if (this.running) {
            return;
        }
        try {
            this.serverSocket = new ServerSocket(this.rconPort, 0, InetAddress.getByName(this.hostname));
            this.serverSocket.setSoTimeout(500);
            super.startThread();
        }
        catch (IOException lvt_1_1_) {
            this.logWarning("Unable to initialise rcon on " + this.hostname + ":" + this.rconPort + " : " + lvt_1_1_.getMessage());
        }
    }
}

