/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public abstract class NodeProcessor {
    protected IBlockAccess blockaccess;
    protected EntityLiving entity;
    protected final IntHashMap<PathPoint> pointMap = new IntHashMap();
    protected int entitySizeX;
    protected int entitySizeY;
    protected int entitySizeZ;
    protected boolean canEnterDoors;
    protected boolean canBreakDoors;
    protected boolean canSwim;

    public void initProcessor(IBlockAccess p_initProcessor_1_, EntityLiving p_initProcessor_2_) {
        this.blockaccess = p_initProcessor_1_;
        this.entity = p_initProcessor_2_;
        this.pointMap.clearMap();
        this.entitySizeX = MathHelper.floor(p_initProcessor_2_.width + 1.0f);
        this.entitySizeY = MathHelper.floor(p_initProcessor_2_.height + 1.0f);
        this.entitySizeZ = MathHelper.floor(p_initProcessor_2_.width + 1.0f);
    }

    public void postProcess() {
        this.blockaccess = null;
        this.entity = null;
    }

    protected PathPoint openPoint(int p_openPoint_1_, int p_openPoint_2_, int p_openPoint_3_) {
        int lvt_4_1_ = PathPoint.makeHash(p_openPoint_1_, p_openPoint_2_, p_openPoint_3_);
        PathPoint lvt_5_1_ = this.pointMap.lookup(lvt_4_1_);
        if (lvt_5_1_ == null) {
            lvt_5_1_ = new PathPoint(p_openPoint_1_, p_openPoint_2_, p_openPoint_3_);
            this.pointMap.addKey(lvt_4_1_, lvt_5_1_);
        }
        return lvt_5_1_;
    }

    public abstract PathPoint getStart();

    public abstract PathPoint getPathPointToCoords(double var1, double var3, double var5);

    public abstract int findPathOptions(PathPoint[] var1, PathPoint var2, PathPoint var3, float var4);

    public abstract PathNodeType getPathNodeType(IBlockAccess var1, int var2, int var3, int var4, EntityLiving var5, int var6, int var7, int var8, boolean var9, boolean var10);

    public abstract PathNodeType getPathNodeType(IBlockAccess var1, int var2, int var3, int var4);

    public void setCanEnterDoors(boolean p_setCanEnterDoors_1_) {
        this.canEnterDoors = p_setCanEnterDoors_1_;
    }

    public void setCanBreakDoors(boolean p_setCanBreakDoors_1_) {
        this.canBreakDoors = p_setCanBreakDoors_1_;
    }

    public void setCanSwim(boolean p_setCanSwim_1_) {
        this.canSwim = p_setCanSwim_1_;
    }

    public boolean getCanEnterDoors() {
        return this.canEnterDoors;
    }

    public boolean getCanBreakDoors() {
        return this.canBreakDoors;
    }

    public boolean getCanSwim() {
        return this.canSwim;
    }
}

