/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Path {
    private final PathPoint[] points;
    private PathPoint[] openSet = new PathPoint[0];
    private PathPoint[] closedSet = new PathPoint[0];
    @SideOnly(value=Side.CLIENT)
    private PathPoint target;
    private int currentPathIndex;
    private int pathLength;

    public Path(PathPoint[] p_i2136_1_) {
        this.points = p_i2136_1_;
        this.pathLength = p_i2136_1_.length;
    }

    public void incrementPathIndex() {
        ++this.currentPathIndex;
    }

    public boolean isFinished() {
        return this.currentPathIndex >= this.pathLength;
    }

    @Nullable
    public PathPoint getFinalPathPoint() {
        if (this.pathLength > 0) {
            return this.points[this.pathLength - 1];
        }
        return null;
    }

    public PathPoint getPathPointFromIndex(int p_getPathPointFromIndex_1_) {
        return this.points[p_getPathPointFromIndex_1_];
    }

    public void setPoint(int p_setPoint_1_, PathPoint p_setPoint_2_) {
        this.points[p_setPoint_1_] = p_setPoint_2_;
    }

    public int getCurrentPathLength() {
        return this.pathLength;
    }

    public void setCurrentPathLength(int p_setCurrentPathLength_1_) {
        this.pathLength = p_setCurrentPathLength_1_;
    }

    public int getCurrentPathIndex() {
        return this.currentPathIndex;
    }

    public void setCurrentPathIndex(int p_setCurrentPathIndex_1_) {
        this.currentPathIndex = p_setCurrentPathIndex_1_;
    }

    public Vec3d getVectorFromIndex(Entity p_getVectorFromIndex_1_, int p_getVectorFromIndex_2_) {
        double lvt_3_1_ = (double)this.points[p_getVectorFromIndex_2_].xCoord + (double)((int)(p_getVectorFromIndex_1_.width + 1.0f)) * 0.5;
        double lvt_5_1_ = this.points[p_getVectorFromIndex_2_].yCoord;
        double lvt_7_1_ = (double)this.points[p_getVectorFromIndex_2_].zCoord + (double)((int)(p_getVectorFromIndex_1_.width + 1.0f)) * 0.5;
        return new Vec3d(lvt_3_1_, lvt_5_1_, lvt_7_1_);
    }

    public Vec3d getPosition(Entity p_getPosition_1_) {
        return this.getVectorFromIndex(p_getPosition_1_, this.currentPathIndex);
    }

    public Vec3d getCurrentPos() {
        PathPoint lvt_1_1_ = this.points[this.currentPathIndex];
        return new Vec3d(lvt_1_1_.xCoord, lvt_1_1_.yCoord, lvt_1_1_.zCoord);
    }

    public boolean isSamePath(Path p_isSamePath_1_) {
        if (p_isSamePath_1_ == null) {
            return false;
        }
        if (p_isSamePath_1_.points.length != this.points.length) {
            return false;
        }
        for (int lvt_2_1_ = 0; lvt_2_1_ < this.points.length; ++lvt_2_1_) {
            if (this.points[lvt_2_1_].xCoord == p_isSamePath_1_.points[lvt_2_1_].xCoord && this.points[lvt_2_1_].yCoord == p_isSamePath_1_.points[lvt_2_1_].yCoord && this.points[lvt_2_1_].zCoord == p_isSamePath_1_.points[lvt_2_1_].zCoord) continue;
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public PathPoint[] getOpenSet() {
        return this.openSet;
    }

    @SideOnly(value=Side.CLIENT)
    public PathPoint[] getClosedSet() {
        return this.closedSet;
    }

    @SideOnly(value=Side.CLIENT)
    public PathPoint getTarget() {
        return this.target;
    }

    @SideOnly(value=Side.CLIENT)
    public static Path read(PacketBuffer p_read_0_) {
        int lvt_1_1_ = p_read_0_.readInt();
        PathPoint lvt_2_1_ = PathPoint.createFromBuffer(p_read_0_);
        PathPoint[] lvt_3_1_ = new PathPoint[p_read_0_.readInt()];
        for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_3_1_.length; ++lvt_4_1_) {
            lvt_3_1_[lvt_4_1_] = PathPoint.createFromBuffer(p_read_0_);
        }
        PathPoint[] lvt_4_2_ = new PathPoint[p_read_0_.readInt()];
        for (int lvt_5_1_ = 0; lvt_5_1_ < lvt_4_2_.length; ++lvt_5_1_) {
            lvt_4_2_[lvt_5_1_] = PathPoint.createFromBuffer(p_read_0_);
        }
        PathPoint[] lvt_5_2_ = new PathPoint[p_read_0_.readInt()];
        for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_5_2_.length; ++lvt_6_1_) {
            lvt_5_2_[lvt_6_1_] = PathPoint.createFromBuffer(p_read_0_);
        }
        Path lvt_6_2_ = new Path(lvt_3_1_);
        lvt_6_2_.openSet = lvt_4_2_;
        lvt_6_2_.closedSet = lvt_5_2_;
        lvt_6_2_.target = lvt_2_1_;
        lvt_6_2_.currentPathIndex = lvt_1_1_;
        return lvt_6_2_;
    }
}

