/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathHeap;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PathFinder {
    private final PathHeap path = new PathHeap();
    private final Set<PathPoint> closedSet = Sets.newHashSet();
    private final PathPoint[] pathOptions = new PathPoint[32];
    private final NodeProcessor nodeProcessor;

    public PathFinder(NodeProcessor p_i46652_1_) {
        this.nodeProcessor = p_i46652_1_;
    }

    @Nullable
    public Path findPath(IBlockAccess p_findPath_1_, EntityLiving p_findPath_2_, Entity p_findPath_3_, float p_findPath_4_) {
        return this.findPath(p_findPath_1_, p_findPath_2_, p_findPath_3_.posX, p_findPath_3_.getEntityBoundingBox().minY, p_findPath_3_.posZ, p_findPath_4_);
    }

    @Nullable
    public Path findPath(IBlockAccess p_findPath_1_, EntityLiving p_findPath_2_, BlockPos p_findPath_3_, float p_findPath_4_) {
        return this.findPath(p_findPath_1_, p_findPath_2_, (float)p_findPath_3_.getX() + 0.5f, (float)p_findPath_3_.getY() + 0.5f, (float)p_findPath_3_.getZ() + 0.5f, p_findPath_4_);
    }

    @Nullable
    private Path findPath(IBlockAccess p_findPath_1_, EntityLiving p_findPath_2_, double p_findPath_3_, double p_findPath_5_, double p_findPath_7_, float p_findPath_9_) {
        this.path.clearPath();
        this.nodeProcessor.initProcessor(p_findPath_1_, p_findPath_2_);
        PathPoint lvt_10_1_ = this.nodeProcessor.getStart();
        PathPoint lvt_11_1_ = this.nodeProcessor.getPathPointToCoords(p_findPath_3_, p_findPath_5_, p_findPath_7_);
        Path lvt_12_1_ = this.findPath(lvt_10_1_, lvt_11_1_, p_findPath_9_);
        this.nodeProcessor.postProcess();
        return lvt_12_1_;
    }

    @Nullable
    private Path findPath(PathPoint p_findPath_1_, PathPoint p_findPath_2_, float p_findPath_3_) {
        p_findPath_1_.totalPathDistance = 0.0f;
        p_findPath_1_.distanceToTarget = p_findPath_1_.distanceToNext = p_findPath_1_.distanceManhattan(p_findPath_2_);
        this.path.clearPath();
        this.closedSet.clear();
        this.path.addPoint(p_findPath_1_);
        PathPoint lvt_4_1_ = p_findPath_1_;
        int lvt_5_1_ = 0;
        while (!this.path.isPathEmpty() && ++lvt_5_1_ < 200) {
            PathPoint lvt_6_1_ = this.path.dequeue();
            if (lvt_6_1_.equals(p_findPath_2_)) {
                lvt_4_1_ = p_findPath_2_;
                break;
            }
            if (lvt_6_1_.distanceManhattan(p_findPath_2_) < lvt_4_1_.distanceManhattan(p_findPath_2_)) {
                lvt_4_1_ = lvt_6_1_;
            }
            lvt_6_1_.visited = true;
            int lvt_7_1_ = this.nodeProcessor.findPathOptions(this.pathOptions, lvt_6_1_, p_findPath_2_, p_findPath_3_);
            for (int lvt_8_1_ = 0; lvt_8_1_ < lvt_7_1_; ++lvt_8_1_) {
                PathPoint lvt_9_1_ = this.pathOptions[lvt_8_1_];
                float lvt_10_1_ = lvt_6_1_.distanceManhattan(lvt_9_1_);
                lvt_9_1_.distanceFromOrigin = lvt_6_1_.distanceFromOrigin + lvt_10_1_;
                lvt_9_1_.cost = lvt_10_1_ + lvt_9_1_.costMalus;
                float lvt_11_1_ = lvt_6_1_.totalPathDistance + lvt_9_1_.cost;
                if (!(lvt_9_1_.distanceFromOrigin < p_findPath_3_) || lvt_9_1_.isAssigned() && !(lvt_11_1_ < lvt_9_1_.totalPathDistance)) continue;
                lvt_9_1_.previous = lvt_6_1_;
                lvt_9_1_.totalPathDistance = lvt_11_1_;
                lvt_9_1_.distanceToNext = lvt_9_1_.distanceManhattan(p_findPath_2_) + lvt_9_1_.costMalus;
                if (lvt_9_1_.isAssigned()) {
                    this.path.changeDistance(lvt_9_1_, lvt_9_1_.totalPathDistance + lvt_9_1_.distanceToNext);
                    continue;
                }
                lvt_9_1_.distanceToTarget = lvt_9_1_.totalPathDistance + lvt_9_1_.distanceToNext;
                this.path.addPoint(lvt_9_1_);
            }
        }
        if (lvt_4_1_ == p_findPath_1_) {
            return null;
        }
        Path lvt_6_2_ = this.createEntityPath(p_findPath_1_, lvt_4_1_);
        return lvt_6_2_;
    }

    private Path createEntityPath(PathPoint p_createEntityPath_1_, PathPoint p_createEntityPath_2_) {
        int lvt_3_1_ = 1;
        PathPoint lvt_4_1_ = p_createEntityPath_2_;
        while (lvt_4_1_.previous != null) {
            ++lvt_3_1_;
            lvt_4_1_ = lvt_4_1_.previous;
        }
        PathPoint[] lvt_5_1_ = new PathPoint[lvt_3_1_];
        lvt_4_1_ = p_createEntityPath_2_;
        lvt_5_1_[--lvt_3_1_] = lvt_4_1_;
        while (lvt_4_1_.previous != null) {
            lvt_4_1_ = lvt_4_1_.previous;
            lvt_5_1_[--lvt_3_1_] = lvt_4_1_;
        }
        return new Path(lvt_5_1_);
    }
}

