/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class PathNavigate {
    protected EntityLiving theEntity;
    protected World world;
    @Nullable
    protected Path currentPath;
    protected double speed;
    private final IAttributeInstance pathSearchRange;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3d lastPosCheck = Vec3d.ZERO;
    private Vec3d timeoutCachedNode = Vec3d.ZERO;
    private long timeoutTimer;
    private long lastTimeoutCheck;
    private double timeoutLimit;
    private float maxDistanceToWaypoint = 0.5f;
    private boolean tryUpdatePath;
    private long lastTimeUpdated;
    protected NodeProcessor nodeProcessor;
    private BlockPos targetPos;
    private final PathFinder pathFinder;

    public PathNavigate(EntityLiving p_i1671_1_, World p_i1671_2_) {
        this.theEntity = p_i1671_1_;
        this.world = p_i1671_2_;
        this.pathSearchRange = p_i1671_1_.getEntityAttribute(SharedMonsterAttributes.FOLLOW_RANGE);
        this.pathFinder = this.getPathFinder();
    }

    protected abstract PathFinder getPathFinder();

    public void setSpeed(double p_setSpeed_1_) {
        this.speed = p_setSpeed_1_;
    }

    public float getPathSearchRange() {
        return (float)this.pathSearchRange.getAttributeValue();
    }

    public boolean canUpdatePathOnTimeout() {
        return this.tryUpdatePath;
    }

    public void updatePath() {
        if (this.world.getTotalWorldTime() - this.lastTimeUpdated > 20L) {
            if (this.targetPos != null) {
                this.currentPath = null;
                this.currentPath = this.getPathToPos(this.targetPos);
                this.lastTimeUpdated = this.world.getTotalWorldTime();
                this.tryUpdatePath = false;
            }
        } else {
            this.tryUpdatePath = true;
        }
    }

    @Nullable
    public final Path getPathToXYZ(double p_getPathToXYZ_1_, double p_getPathToXYZ_3_, double p_getPathToXYZ_5_) {
        return this.getPathToPos(new BlockPos(p_getPathToXYZ_1_, p_getPathToXYZ_3_, p_getPathToXYZ_5_));
    }

    @Nullable
    public Path getPathToPos(BlockPos p_getPathToPos_1_) {
        if (!this.canNavigate()) {
            return null;
        }
        if (this.currentPath != null && !this.currentPath.isFinished() && p_getPathToPos_1_.equals(this.targetPos)) {
            return this.currentPath;
        }
        this.targetPos = p_getPathToPos_1_;
        float lvt_2_1_ = this.getPathSearchRange();
        this.world.theProfiler.startSection("pathfind");
        BlockPos lvt_3_1_ = new BlockPos(this.theEntity);
        int lvt_4_1_ = (int)(lvt_2_1_ + 8.0f);
        ChunkCache lvt_5_1_ = new ChunkCache(this.world, lvt_3_1_.add(-lvt_4_1_, -lvt_4_1_, -lvt_4_1_), lvt_3_1_.add(lvt_4_1_, lvt_4_1_, lvt_4_1_), 0);
        Path lvt_6_1_ = this.pathFinder.findPath((IBlockAccess)lvt_5_1_, this.theEntity, this.targetPos, lvt_2_1_);
        this.world.theProfiler.endSection();
        return lvt_6_1_;
    }

    @Nullable
    public Path getPathToEntityLiving(Entity p_getPathToEntityLiving_1_) {
        if (!this.canNavigate()) {
            return null;
        }
        BlockPos lvt_2_1_ = new BlockPos(p_getPathToEntityLiving_1_);
        if (this.currentPath != null && !this.currentPath.isFinished() && lvt_2_1_.equals(this.targetPos)) {
            return this.currentPath;
        }
        this.targetPos = lvt_2_1_;
        float lvt_3_1_ = this.getPathSearchRange();
        this.world.theProfiler.startSection("pathfind");
        BlockPos lvt_4_1_ = new BlockPos(this.theEntity).up();
        int lvt_5_1_ = (int)(lvt_3_1_ + 16.0f);
        ChunkCache lvt_6_1_ = new ChunkCache(this.world, lvt_4_1_.add(-lvt_5_1_, -lvt_5_1_, -lvt_5_1_), lvt_4_1_.add(lvt_5_1_, lvt_5_1_, lvt_5_1_), 0);
        Path lvt_7_1_ = this.pathFinder.findPath((IBlockAccess)lvt_6_1_, this.theEntity, p_getPathToEntityLiving_1_, lvt_3_1_);
        this.world.theProfiler.endSection();
        return lvt_7_1_;
    }

    public boolean tryMoveToXYZ(double p_tryMoveToXYZ_1_, double p_tryMoveToXYZ_3_, double p_tryMoveToXYZ_5_, double p_tryMoveToXYZ_7_) {
        return this.setPath(this.getPathToXYZ(p_tryMoveToXYZ_1_, p_tryMoveToXYZ_3_, p_tryMoveToXYZ_5_), p_tryMoveToXYZ_7_);
    }

    public boolean tryMoveToEntityLiving(Entity p_tryMoveToEntityLiving_1_, double p_tryMoveToEntityLiving_2_) {
        Path lvt_4_1_ = this.getPathToEntityLiving(p_tryMoveToEntityLiving_1_);
        return lvt_4_1_ != null && this.setPath(lvt_4_1_, p_tryMoveToEntityLiving_2_);
    }

    public boolean setPath(Path p_setPath_1_, double p_setPath_2_) {
        if (p_setPath_1_ == null) {
            this.currentPath = null;
            return false;
        }
        if (!p_setPath_1_.isSamePath(this.currentPath)) {
            this.currentPath = p_setPath_1_;
        }
        this.removeSunnyPath();
        if (this.currentPath.getCurrentPathLength() == 0) {
            return false;
        }
        this.speed = p_setPath_2_;
        Vec3d lvt_4_1_ = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck = lvt_4_1_;
        return true;
    }

    @Nullable
    public Path getPath() {
        return this.currentPath;
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (this.tryUpdatePath) {
            this.updatePath();
        }
        if (this.noPath()) {
            return;
        }
        if (this.canNavigate()) {
            this.pathFollow();
        } else if (this.currentPath != null && this.currentPath.getCurrentPathIndex() < this.currentPath.getCurrentPathLength()) {
            Vec3d lvt_1_1_ = this.getEntityPosition();
            Vec3d lvt_2_1_ = this.currentPath.getVectorFromIndex(this.theEntity, this.currentPath.getCurrentPathIndex());
            if (lvt_1_1_.yCoord > lvt_2_1_.yCoord && !this.theEntity.onGround && MathHelper.floor(lvt_1_1_.xCoord) == MathHelper.floor(lvt_2_1_.xCoord) && MathHelper.floor(lvt_1_1_.zCoord) == MathHelper.floor(lvt_2_1_.zCoord)) {
                this.currentPath.setCurrentPathIndex(this.currentPath.getCurrentPathIndex() + 1);
            }
        }
        if (this.noPath()) {
            return;
        }
        Vec3d lvt_1_2_ = this.currentPath.getPosition(this.theEntity);
        if (lvt_1_2_ == null) {
            return;
        }
        BlockPos lvt_2_2_ = new BlockPos(lvt_1_2_).down();
        AxisAlignedBB lvt_3_1_ = this.world.getBlockState(lvt_2_2_).getBoundingBox(this.world, lvt_2_2_);
        lvt_1_2_ = lvt_1_2_.subtract(0.0, 1.0 - lvt_3_1_.maxY, 0.0);
        this.theEntity.getMoveHelper().setMoveTo(lvt_1_2_.xCoord, lvt_1_2_.yCoord, lvt_1_2_.zCoord, this.speed);
    }

    protected void pathFollow() {
        Vec3d lvt_1_1_ = this.getEntityPosition();
        int lvt_2_1_ = this.currentPath.getCurrentPathLength();
        for (int lvt_3_1_ = this.currentPath.getCurrentPathIndex(); lvt_3_1_ < this.currentPath.getCurrentPathLength(); ++lvt_3_1_) {
            if ((double)this.currentPath.getPathPointFromIndex((int)lvt_3_1_).yCoord == Math.floor(lvt_1_1_.yCoord)) continue;
            lvt_2_1_ = lvt_3_1_;
            break;
        }
        this.maxDistanceToWaypoint = this.theEntity.width > 0.75f ? this.theEntity.width / 2.0f : 0.75f - this.theEntity.width / 2.0f;
        Vec3d lvt_3_2_ = this.currentPath.getCurrentPos();
        if (MathHelper.abs((float)(this.theEntity.posX - (lvt_3_2_.xCoord + 0.5))) < this.maxDistanceToWaypoint && MathHelper.abs((float)(this.theEntity.posZ - (lvt_3_2_.zCoord + 0.5))) < this.maxDistanceToWaypoint && Math.abs(this.theEntity.posY - lvt_3_2_.yCoord) < 1.0) {
            this.currentPath.setCurrentPathIndex(this.currentPath.getCurrentPathIndex() + 1);
        }
        int lvt_4_1_ = MathHelper.ceil(this.theEntity.width);
        int lvt_5_1_ = MathHelper.ceil(this.theEntity.height);
        int lvt_6_1_ = lvt_4_1_;
        for (int lvt_7_1_ = lvt_2_1_ - 1; lvt_7_1_ >= this.currentPath.getCurrentPathIndex(); --lvt_7_1_) {
            if (!this.isDirectPathBetweenPoints(lvt_1_1_, this.currentPath.getVectorFromIndex(this.theEntity, lvt_7_1_), lvt_4_1_, lvt_5_1_, lvt_6_1_)) continue;
            this.currentPath.setCurrentPathIndex(lvt_7_1_);
            break;
        }
        this.checkForStuck(lvt_1_1_);
    }

    protected void checkForStuck(Vec3d p_checkForStuck_1_) {
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (p_checkForStuck_1_.squareDistanceTo(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = p_checkForStuck_1_;
        }
        if (this.currentPath != null && !this.currentPath.isFinished()) {
            Vec3d lvt_2_1_ = this.currentPath.getCurrentPos();
            if (lvt_2_1_.equals(this.timeoutCachedNode)) {
                this.timeoutTimer += System.currentTimeMillis() - this.lastTimeoutCheck;
            } else {
                this.timeoutCachedNode = lvt_2_1_;
                double lvt_3_1_ = p_checkForStuck_1_.distanceTo(this.timeoutCachedNode);
                double d = this.timeoutLimit = this.theEntity.getAIMoveSpeed() > 0.0f ? lvt_3_1_ / (double)this.theEntity.getAIMoveSpeed() * 1000.0 : 0.0;
            }
            if (this.timeoutLimit > 0.0 && (double)this.timeoutTimer > this.timeoutLimit * 3.0) {
                this.timeoutCachedNode = Vec3d.ZERO;
                this.timeoutTimer = 0L;
                this.timeoutLimit = 0.0;
                this.clearPathEntity();
            }
            this.lastTimeoutCheck = System.currentTimeMillis();
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.isFinished();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    protected abstract Vec3d getEntityPosition();

    protected abstract boolean canNavigate();

    protected boolean isInLiquid() {
        return this.theEntity.isInWater() || this.theEntity.isInLava();
    }

    protected void removeSunnyPath() {
    }

    protected abstract boolean isDirectPathBetweenPoints(Vec3d var1, Vec3d var2, int var3, int var4, int var5);

    public boolean canEntityStandOnPos(BlockPos p_canEntityStandOnPos_1_) {
        return this.world.getBlockState(p_canEntityStandOnPos_1_.down()).isFullBlock();
    }

    public NodeProcessor getNodeProcessor() {
        return this.nodeProcessor;
    }
}

