/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class PathNavigateClimber
extends PathNavigateGround {
    private BlockPos targetPosition;

    public PathNavigateClimber(EntityLiving p_i45874_1_, World p_i45874_2_) {
        super(p_i45874_1_, p_i45874_2_);
    }

    @Override
    public Path getPathToPos(BlockPos p_getPathToPos_1_) {
        this.targetPosition = p_getPathToPos_1_;
        return super.getPathToPos(p_getPathToPos_1_);
    }

    @Override
    public Path getPathToEntityLiving(Entity p_getPathToEntityLiving_1_) {
        this.targetPosition = new BlockPos(p_getPathToEntityLiving_1_);
        return super.getPathToEntityLiving(p_getPathToEntityLiving_1_);
    }

    @Override
    public boolean tryMoveToEntityLiving(Entity p_tryMoveToEntityLiving_1_, double p_tryMoveToEntityLiving_2_) {
        Path lvt_4_1_ = this.getPathToEntityLiving(p_tryMoveToEntityLiving_1_);
        if (lvt_4_1_ != null) {
            return this.setPath(lvt_4_1_, p_tryMoveToEntityLiving_2_);
        }
        this.targetPosition = new BlockPos(p_tryMoveToEntityLiving_1_);
        this.speed = p_tryMoveToEntityLiving_2_;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdateNavigation() {
        block5: {
            block4: {
                if (!this.noPath()) {
                    super.onUpdateNavigation();
                    return;
                }
                if (this.targetPosition == null) return;
                double lvt_1_1_ = this.theEntity.width * this.theEntity.width;
                if (this.theEntity.getDistanceSqToCenter(this.targetPosition) < lvt_1_1_) break block4;
                if (!(this.theEntity.posY > (double)this.targetPosition.getY())) break block5;
                BlockPos blockPos = new BlockPos(this.targetPosition.getX(), MathHelper.floor(this.theEntity.posY), this.targetPosition.getZ());
                if (!(this.theEntity.getDistanceSqToCenter(blockPos) < lvt_1_1_)) break block5;
            }
            this.targetPosition = null;
            return;
        }
        this.theEntity.getMoveHelper().setMoveTo(this.targetPosition.getX(), this.targetPosition.getY(), this.targetPosition.getZ(), this.speed);
    }
}

