/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PathNavigateGround
extends PathNavigate {
    private boolean shouldAvoidSun;

    public PathNavigateGround(EntityLiving p_i45875_1_, World p_i45875_2_) {
        super(p_i45875_1_, p_i45875_2_);
    }

    @Override
    protected PathFinder getPathFinder() {
        this.nodeProcessor = new WalkNodeProcessor();
        this.nodeProcessor.setCanEnterDoors(true);
        return new PathFinder(this.nodeProcessor);
    }

    @Override
    protected boolean canNavigate() {
        return this.theEntity.onGround || this.getCanSwim() && this.isInLiquid() || this.theEntity.isRiding();
    }

    @Override
    protected Vec3d getEntityPosition() {
        return new Vec3d(this.theEntity.posX, this.getPathablePosY(), this.theEntity.posZ);
    }

    @Override
    public Path getPathToPos(BlockPos p_getPathToPos_1_) {
        if (this.world.getBlockState(p_getPathToPos_1_).getMaterial() == Material.AIR) {
            BlockPos lvt_2_1_ = p_getPathToPos_1_.down();
            while (lvt_2_1_.getY() > 0 && this.world.getBlockState(lvt_2_1_).getMaterial() == Material.AIR) {
                lvt_2_1_ = lvt_2_1_.down();
            }
            if (lvt_2_1_.getY() > 0) {
                return super.getPathToPos(lvt_2_1_.up());
            }
            while (lvt_2_1_.getY() < this.world.getHeight() && this.world.getBlockState(lvt_2_1_).getMaterial() == Material.AIR) {
                lvt_2_1_ = lvt_2_1_.up();
            }
            p_getPathToPos_1_ = lvt_2_1_;
        }
        if (this.world.getBlockState(p_getPathToPos_1_).getMaterial().isSolid()) {
            BlockPos lvt_2_2_ = p_getPathToPos_1_.up();
            while (lvt_2_2_.getY() < this.world.getHeight() && this.world.getBlockState(lvt_2_2_).getMaterial().isSolid()) {
                lvt_2_2_ = lvt_2_2_.up();
            }
            return super.getPathToPos(lvt_2_2_);
        }
        return super.getPathToPos(p_getPathToPos_1_);
    }

    @Override
    public Path getPathToEntityLiving(Entity p_getPathToEntityLiving_1_) {
        return this.getPathToPos(new BlockPos(p_getPathToEntityLiving_1_));
    }

    private int getPathablePosY() {
        if (!this.theEntity.isInWater() || !this.getCanSwim()) {
            return (int)(this.theEntity.getEntityBoundingBox().minY + 0.5);
        }
        int lvt_1_1_ = (int)this.theEntity.getEntityBoundingBox().minY;
        Block lvt_2_1_ = this.world.getBlockState(new BlockPos(MathHelper.floor(this.theEntity.posX), lvt_1_1_, MathHelper.floor(this.theEntity.posZ))).getBlock();
        int lvt_3_1_ = 0;
        while (lvt_2_1_ == Blocks.FLOWING_WATER || lvt_2_1_ == Blocks.WATER) {
            lvt_2_1_ = this.world.getBlockState(new BlockPos(MathHelper.floor(this.theEntity.posX), ++lvt_1_1_, MathHelper.floor(this.theEntity.posZ))).getBlock();
            if (++lvt_3_1_ <= 16) continue;
            return (int)this.theEntity.getEntityBoundingBox().minY;
        }
        return lvt_1_1_;
    }

    @Override
    protected void removeSunnyPath() {
        super.removeSunnyPath();
        for (int lvt_1_1_ = 0; lvt_1_1_ < this.currentPath.getCurrentPathLength(); ++lvt_1_1_) {
            PathPoint lvt_2_1_ = this.currentPath.getPathPointFromIndex(lvt_1_1_);
            PathPoint lvt_3_1_ = lvt_1_1_ + 1 < this.currentPath.getCurrentPathLength() ? this.currentPath.getPathPointFromIndex(lvt_1_1_ + 1) : null;
            IBlockState lvt_4_1_ = this.world.getBlockState(new BlockPos(lvt_2_1_.xCoord, lvt_2_1_.yCoord, lvt_2_1_.zCoord));
            Block lvt_5_1_ = lvt_4_1_.getBlock();
            if (lvt_5_1_ != Blocks.CAULDRON) continue;
            this.currentPath.setPoint(lvt_1_1_, lvt_2_1_.cloneMove(lvt_2_1_.xCoord, lvt_2_1_.yCoord + 1, lvt_2_1_.zCoord));
            if (lvt_3_1_ == null || lvt_2_1_.yCoord < lvt_3_1_.yCoord) continue;
            this.currentPath.setPoint(lvt_1_1_ + 1, lvt_3_1_.cloneMove(lvt_3_1_.xCoord, lvt_2_1_.yCoord + 1, lvt_3_1_.zCoord));
        }
        if (this.shouldAvoidSun) {
            if (this.world.canSeeSky(new BlockPos(MathHelper.floor(this.theEntity.posX), (int)(this.theEntity.getEntityBoundingBox().minY + 0.5), MathHelper.floor(this.theEntity.posZ)))) {
                return;
            }
            for (int lvt_1_2_ = 0; lvt_1_2_ < this.currentPath.getCurrentPathLength(); ++lvt_1_2_) {
                PathPoint lvt_2_2_ = this.currentPath.getPathPointFromIndex(lvt_1_2_);
                if (!this.world.canSeeSky(new BlockPos(lvt_2_2_.xCoord, lvt_2_2_.yCoord, lvt_2_2_.zCoord))) continue;
                this.currentPath.setCurrentPathLength(lvt_1_2_ - 1);
                return;
            }
        }
    }

    @Override
    protected boolean isDirectPathBetweenPoints(Vec3d p_isDirectPathBetweenPoints_1_, Vec3d p_isDirectPathBetweenPoints_2_, int p_isDirectPathBetweenPoints_3_, int p_isDirectPathBetweenPoints_4_, int p_isDirectPathBetweenPoints_5_) {
        int lvt_6_1_ = MathHelper.floor(p_isDirectPathBetweenPoints_1_.xCoord);
        int lvt_7_1_ = MathHelper.floor(p_isDirectPathBetweenPoints_1_.zCoord);
        double lvt_8_1_ = p_isDirectPathBetweenPoints_2_.xCoord - p_isDirectPathBetweenPoints_1_.xCoord;
        double lvt_10_1_ = p_isDirectPathBetweenPoints_2_.zCoord - p_isDirectPathBetweenPoints_1_.zCoord;
        double lvt_12_1_ = lvt_8_1_ * lvt_8_1_ + lvt_10_1_ * lvt_10_1_;
        if (lvt_12_1_ < 1.0E-8) {
            return false;
        }
        double lvt_14_1_ = 1.0 / Math.sqrt(lvt_12_1_);
        if (!this.isSafeToStandAt(lvt_6_1_, (int)p_isDirectPathBetweenPoints_1_.yCoord, lvt_7_1_, p_isDirectPathBetweenPoints_3_ += 2, p_isDirectPathBetweenPoints_4_, p_isDirectPathBetweenPoints_5_ += 2, p_isDirectPathBetweenPoints_1_, lvt_8_1_ *= lvt_14_1_, lvt_10_1_ *= lvt_14_1_)) {
            return false;
        }
        p_isDirectPathBetweenPoints_3_ -= 2;
        p_isDirectPathBetweenPoints_5_ -= 2;
        double lvt_16_1_ = 1.0 / Math.abs(lvt_8_1_);
        double lvt_18_1_ = 1.0 / Math.abs(lvt_10_1_);
        double lvt_20_1_ = (double)lvt_6_1_ - p_isDirectPathBetweenPoints_1_.xCoord;
        double lvt_22_1_ = (double)lvt_7_1_ - p_isDirectPathBetweenPoints_1_.zCoord;
        if (lvt_8_1_ >= 0.0) {
            lvt_20_1_ += 1.0;
        }
        if (lvt_10_1_ >= 0.0) {
            lvt_22_1_ += 1.0;
        }
        lvt_20_1_ /= lvt_8_1_;
        lvt_22_1_ /= lvt_10_1_;
        int lvt_24_1_ = lvt_8_1_ < 0.0 ? -1 : 1;
        int lvt_25_1_ = lvt_10_1_ < 0.0 ? -1 : 1;
        int lvt_26_1_ = MathHelper.floor(p_isDirectPathBetweenPoints_2_.xCoord);
        int lvt_27_1_ = MathHelper.floor(p_isDirectPathBetweenPoints_2_.zCoord);
        int lvt_28_1_ = lvt_26_1_ - lvt_6_1_;
        int lvt_29_1_ = lvt_27_1_ - lvt_7_1_;
        while (lvt_28_1_ * lvt_24_1_ > 0 || lvt_29_1_ * lvt_25_1_ > 0) {
            if (lvt_20_1_ < lvt_22_1_) {
                lvt_20_1_ += lvt_16_1_;
                lvt_28_1_ = lvt_26_1_ - (lvt_6_1_ += lvt_24_1_);
            } else {
                lvt_22_1_ += lvt_18_1_;
                lvt_29_1_ = lvt_27_1_ - (lvt_7_1_ += lvt_25_1_);
            }
            if (this.isSafeToStandAt(lvt_6_1_, (int)p_isDirectPathBetweenPoints_1_.yCoord, lvt_7_1_, p_isDirectPathBetweenPoints_3_, p_isDirectPathBetweenPoints_4_, p_isDirectPathBetweenPoints_5_, p_isDirectPathBetweenPoints_1_, lvt_8_1_, lvt_10_1_)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int p_isSafeToStandAt_1_, int p_isSafeToStandAt_2_, int p_isSafeToStandAt_3_, int p_isSafeToStandAt_4_, int p_isSafeToStandAt_5_, int p_isSafeToStandAt_6_, Vec3d p_isSafeToStandAt_7_, double p_isSafeToStandAt_8_, double p_isSafeToStandAt_10_) {
        int lvt_12_1_ = p_isSafeToStandAt_1_ - p_isSafeToStandAt_4_ / 2;
        int lvt_13_1_ = p_isSafeToStandAt_3_ - p_isSafeToStandAt_6_ / 2;
        if (!this.isPositionClear(lvt_12_1_, p_isSafeToStandAt_2_, lvt_13_1_, p_isSafeToStandAt_4_, p_isSafeToStandAt_5_, p_isSafeToStandAt_6_, p_isSafeToStandAt_7_, p_isSafeToStandAt_8_, p_isSafeToStandAt_10_)) {
            return false;
        }
        for (int lvt_14_1_ = lvt_12_1_; lvt_14_1_ < lvt_12_1_ + p_isSafeToStandAt_4_; ++lvt_14_1_) {
            for (int lvt_15_1_ = lvt_13_1_; lvt_15_1_ < lvt_13_1_ + p_isSafeToStandAt_6_; ++lvt_15_1_) {
                double lvt_16_1_ = (double)lvt_14_1_ + 0.5 - p_isSafeToStandAt_7_.xCoord;
                double lvt_18_1_ = (double)lvt_15_1_ + 0.5 - p_isSafeToStandAt_7_.zCoord;
                if (lvt_16_1_ * p_isSafeToStandAt_8_ + lvt_18_1_ * p_isSafeToStandAt_10_ < 0.0) continue;
                PathNodeType lvt_20_1_ = this.nodeProcessor.getPathNodeType(this.world, lvt_14_1_, p_isSafeToStandAt_2_ - 1, lvt_15_1_, this.theEntity, p_isSafeToStandAt_4_, p_isSafeToStandAt_5_, p_isSafeToStandAt_6_, true, true);
                if (lvt_20_1_ == PathNodeType.WATER) {
                    return false;
                }
                if (lvt_20_1_ == PathNodeType.LAVA) {
                    return false;
                }
                if (lvt_20_1_ == PathNodeType.OPEN) {
                    return false;
                }
                lvt_20_1_ = this.nodeProcessor.getPathNodeType(this.world, lvt_14_1_, p_isSafeToStandAt_2_, lvt_15_1_, this.theEntity, p_isSafeToStandAt_4_, p_isSafeToStandAt_5_, p_isSafeToStandAt_6_, true, true);
                float lvt_21_1_ = this.theEntity.getPathPriority(lvt_20_1_);
                if (lvt_21_1_ < 0.0f || lvt_21_1_ >= 8.0f) {
                    return false;
                }
                if (lvt_20_1_ != PathNodeType.DAMAGE_FIRE && lvt_20_1_ != PathNodeType.DANGER_FIRE && lvt_20_1_ != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int p_isPositionClear_1_, int p_isPositionClear_2_, int p_isPositionClear_3_, int p_isPositionClear_4_, int p_isPositionClear_5_, int p_isPositionClear_6_, Vec3d p_isPositionClear_7_, double p_isPositionClear_8_, double p_isPositionClear_10_) {
        for (BlockPos lvt_13_1_ : BlockPos.getAllInBox(new BlockPos(p_isPositionClear_1_, p_isPositionClear_2_, p_isPositionClear_3_), new BlockPos(p_isPositionClear_1_ + p_isPositionClear_4_ - 1, p_isPositionClear_2_ + p_isPositionClear_5_ - 1, p_isPositionClear_3_ + p_isPositionClear_6_ - 1))) {
            Block lvt_18_1_;
            double lvt_16_1_;
            double lvt_14_1_ = (double)lvt_13_1_.getX() + 0.5 - p_isPositionClear_7_.xCoord;
            if (lvt_14_1_ * p_isPositionClear_8_ + (lvt_16_1_ = (double)lvt_13_1_.getZ() + 0.5 - p_isPositionClear_7_.zCoord) * p_isPositionClear_10_ < 0.0 || (lvt_18_1_ = this.world.getBlockState(lvt_13_1_).getBlock()).isPassable(this.world, lvt_13_1_)) continue;
            return false;
        }
        return true;
    }

    public void setBreakDoors(boolean p_setBreakDoors_1_) {
        this.nodeProcessor.setCanBreakDoors(p_setBreakDoors_1_);
    }

    public void setEnterDoors(boolean p_setEnterDoors_1_) {
        this.nodeProcessor.setCanEnterDoors(p_setEnterDoors_1_);
    }

    public boolean getEnterDoors() {
        return this.nodeProcessor.getCanEnterDoors();
    }

    public void setCanSwim(boolean p_setCanSwim_1_) {
        this.nodeProcessor.setCanSwim(p_setCanSwim_1_);
    }

    public boolean getCanSwim() {
        return this.nodeProcessor.getCanSwim();
    }

    public void setAvoidSun(boolean p_setAvoidSun_1_) {
        this.shouldAvoidSun = p_setAvoidSun_1_;
    }
}

