/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.SwimNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PathNavigateSwimmer
extends PathNavigate {
    public PathNavigateSwimmer(EntityLiving p_i45873_1_, World p_i45873_2_) {
        super(p_i45873_1_, p_i45873_2_);
    }

    @Override
    protected PathFinder getPathFinder() {
        return new PathFinder(new SwimNodeProcessor());
    }

    @Override
    protected boolean canNavigate() {
        return this.isInLiquid();
    }

    @Override
    protected Vec3d getEntityPosition() {
        return new Vec3d(this.theEntity.posX, this.theEntity.posY + (double)this.theEntity.height * 0.5, this.theEntity.posZ);
    }

    @Override
    protected void pathFollow() {
        Vec3d lvt_1_1_ = this.getEntityPosition();
        float lvt_2_1_ = this.theEntity.width * this.theEntity.width;
        int lvt_3_1_ = 6;
        if (lvt_1_1_.squareDistanceTo(this.currentPath.getVectorFromIndex(this.theEntity, this.currentPath.getCurrentPathIndex())) < (double)lvt_2_1_) {
            this.currentPath.incrementPathIndex();
        }
        for (int lvt_4_1_ = Math.min(this.currentPath.getCurrentPathIndex() + 6, this.currentPath.getCurrentPathLength() - 1); lvt_4_1_ > this.currentPath.getCurrentPathIndex(); --lvt_4_1_) {
            Vec3d lvt_5_1_ = this.currentPath.getVectorFromIndex(this.theEntity, lvt_4_1_);
            if (lvt_5_1_.squareDistanceTo(lvt_1_1_) > 36.0 || !this.isDirectPathBetweenPoints(lvt_1_1_, lvt_5_1_, 0, 0, 0)) continue;
            this.currentPath.setCurrentPathIndex(lvt_4_1_);
            break;
        }
        this.checkForStuck(lvt_1_1_);
    }

    @Override
    protected boolean isDirectPathBetweenPoints(Vec3d p_isDirectPathBetweenPoints_1_, Vec3d p_isDirectPathBetweenPoints_2_, int p_isDirectPathBetweenPoints_3_, int p_isDirectPathBetweenPoints_4_, int p_isDirectPathBetweenPoints_5_) {
        RayTraceResult lvt_6_1_ = this.world.rayTraceBlocks(p_isDirectPathBetweenPoints_1_, new Vec3d(p_isDirectPathBetweenPoints_2_.xCoord, p_isDirectPathBetweenPoints_2_.yCoord + (double)this.theEntity.height * 0.5, p_isDirectPathBetweenPoints_2_.zCoord), false, true, false);
        return lvt_6_1_ == null || lvt_6_1_.typeOfHit == RayTraceResult.Type.MISS;
    }

    @Override
    public boolean canEntityStandOnPos(BlockPos p_canEntityStandOnPos_1_) {
        return !this.world.getBlockState(p_canEntityStandOnPos_1_).isFullBlock();
    }
}

