/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PathPoint {
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    private final int hash;
    public int index = -1;
    public float totalPathDistance;
    public float distanceToNext;
    public float distanceToTarget;
    public PathPoint previous;
    public boolean visited;
    public float distanceFromOrigin;
    public float cost;
    public float costMalus;
    public PathNodeType nodeType = PathNodeType.BLOCKED;

    public PathPoint(int p_i2135_1_, int p_i2135_2_, int p_i2135_3_) {
        this.xCoord = p_i2135_1_;
        this.yCoord = p_i2135_2_;
        this.zCoord = p_i2135_3_;
        this.hash = PathPoint.makeHash(p_i2135_1_, p_i2135_2_, p_i2135_3_);
    }

    public PathPoint cloneMove(int p_cloneMove_1_, int p_cloneMove_2_, int p_cloneMove_3_) {
        PathPoint lvt_4_1_ = new PathPoint(p_cloneMove_1_, p_cloneMove_2_, p_cloneMove_3_);
        lvt_4_1_.index = this.index;
        lvt_4_1_.totalPathDistance = this.totalPathDistance;
        lvt_4_1_.distanceToNext = this.distanceToNext;
        lvt_4_1_.distanceToTarget = this.distanceToTarget;
        lvt_4_1_.previous = this.previous;
        lvt_4_1_.visited = this.visited;
        lvt_4_1_.distanceFromOrigin = this.distanceFromOrigin;
        lvt_4_1_.cost = this.cost;
        lvt_4_1_.costMalus = this.costMalus;
        lvt_4_1_.nodeType = this.nodeType;
        return lvt_4_1_;
    }

    public static int makeHash(int p_makeHash_0_, int p_makeHash_1_, int p_makeHash_2_) {
        return p_makeHash_1_ & 0xFF | (p_makeHash_0_ & Short.MAX_VALUE) << 8 | (p_makeHash_2_ & Short.MAX_VALUE) << 24 | (p_makeHash_0_ < 0 ? Integer.MIN_VALUE : 0) | (p_makeHash_2_ < 0 ? 32768 : 0);
    }

    public float distanceTo(PathPoint p_distanceTo_1_) {
        float lvt_2_1_ = p_distanceTo_1_.xCoord - this.xCoord;
        float lvt_3_1_ = p_distanceTo_1_.yCoord - this.yCoord;
        float lvt_4_1_ = p_distanceTo_1_.zCoord - this.zCoord;
        return MathHelper.sqrt(lvt_2_1_ * lvt_2_1_ + lvt_3_1_ * lvt_3_1_ + lvt_4_1_ * lvt_4_1_);
    }

    public float distanceToSquared(PathPoint p_distanceToSquared_1_) {
        float lvt_2_1_ = p_distanceToSquared_1_.xCoord - this.xCoord;
        float lvt_3_1_ = p_distanceToSquared_1_.yCoord - this.yCoord;
        float lvt_4_1_ = p_distanceToSquared_1_.zCoord - this.zCoord;
        return lvt_2_1_ * lvt_2_1_ + lvt_3_1_ * lvt_3_1_ + lvt_4_1_ * lvt_4_1_;
    }

    public float distanceManhattan(PathPoint p_distanceManhattan_1_) {
        float lvt_2_1_ = Math.abs(p_distanceManhattan_1_.xCoord - this.xCoord);
        float lvt_3_1_ = Math.abs(p_distanceManhattan_1_.yCoord - this.yCoord);
        float lvt_4_1_ = Math.abs(p_distanceManhattan_1_.zCoord - this.zCoord);
        return lvt_2_1_ + lvt_3_1_ + lvt_4_1_;
    }

    public boolean equals(Object p_equals_1_) {
        if (p_equals_1_ instanceof PathPoint) {
            PathPoint lvt_2_1_ = (PathPoint)p_equals_1_;
            return this.hash == lvt_2_1_.hash && this.xCoord == lvt_2_1_.xCoord && this.yCoord == lvt_2_1_.yCoord && this.zCoord == lvt_2_1_.zCoord;
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean isAssigned() {
        return this.index >= 0;
    }

    public String toString() {
        return this.xCoord + ", " + this.yCoord + ", " + this.zCoord;
    }

    @SideOnly(value=Side.CLIENT)
    public static PathPoint createFromBuffer(PacketBuffer p_createFromBuffer_0_) {
        PathPoint lvt_1_1_ = new PathPoint(p_createFromBuffer_0_.readInt(), p_createFromBuffer_0_.readInt(), p_createFromBuffer_0_.readInt());
        lvt_1_1_.distanceFromOrigin = p_createFromBuffer_0_.readFloat();
        lvt_1_1_.cost = p_createFromBuffer_0_.readFloat();
        lvt_1_1_.costMalus = p_createFromBuffer_0_.readFloat();
        lvt_1_1_.visited = p_createFromBuffer_0_.readBoolean();
        lvt_1_1_.nodeType = PathNodeType.values()[p_createFromBuffer_0_.readInt()];
        lvt_1_1_.distanceToTarget = p_createFromBuffer_0_.readFloat();
        return lvt_1_1_;
    }
}

