/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;

public class PathWorldListener
implements IWorldEventListener {
    private final List<PathNavigate> navigations = Lists.newArrayList();

    @Override
    public void notifyBlockUpdate(World p_notifyBlockUpdate_1_, BlockPos p_notifyBlockUpdate_2_, IBlockState p_notifyBlockUpdate_3_, IBlockState p_notifyBlockUpdate_4_, int p_notifyBlockUpdate_5_) {
        if (!this.didBlockChange(p_notifyBlockUpdate_1_, p_notifyBlockUpdate_2_, p_notifyBlockUpdate_3_, p_notifyBlockUpdate_4_)) {
            return;
        }
        int lvt_7_1_ = this.navigations.size();
        for (int lvt_6_1_ = 0; lvt_6_1_ < lvt_7_1_; ++lvt_6_1_) {
            int lvt_13_1_;
            Path lvt_9_1_;
            PathNavigate lvt_8_1_ = this.navigations.get(lvt_6_1_);
            if (lvt_8_1_ == null || lvt_8_1_.canUpdatePathOnTimeout() || (lvt_9_1_ = lvt_8_1_.getPath()) == null || lvt_9_1_.isFinished() || lvt_9_1_.getCurrentPathLength() == 0) continue;
            PathPoint lvt_10_1_ = lvt_8_1_.currentPath.getFinalPathPoint();
            double lvt_11_1_ = p_notifyBlockUpdate_2_.distanceSq(((double)lvt_10_1_.xCoord + lvt_8_1_.theEntity.posX) / 2.0, ((double)lvt_10_1_.yCoord + lvt_8_1_.theEntity.posY) / 2.0, ((double)lvt_10_1_.zCoord + lvt_8_1_.theEntity.posZ) / 2.0);
            if (!(lvt_11_1_ < (double)(lvt_13_1_ = (lvt_9_1_.getCurrentPathLength() - lvt_9_1_.getCurrentPathIndex()) * (lvt_9_1_.getCurrentPathLength() - lvt_9_1_.getCurrentPathIndex())))) continue;
            lvt_8_1_.updatePath();
        }
    }

    protected boolean didBlockChange(World p_didBlockChange_1_, BlockPos p_didBlockChange_2_, IBlockState p_didBlockChange_3_, IBlockState p_didBlockChange_4_) {
        AxisAlignedBB lvt_6_1_;
        AxisAlignedBB lvt_5_1_ = p_didBlockChange_3_.getCollisionBoundingBox(p_didBlockChange_1_, p_didBlockChange_2_);
        return lvt_5_1_ != (lvt_6_1_ = p_didBlockChange_4_.getCollisionBoundingBox(p_didBlockChange_1_, p_didBlockChange_2_)) && (lvt_5_1_ == null || !lvt_5_1_.equals(lvt_6_1_));
    }

    @Override
    public void notifyLightSet(BlockPos p_notifyLightSet_1_) {
    }

    @Override
    public void markBlockRangeForRenderUpdate(int p_markBlockRangeForRenderUpdate_1_, int p_markBlockRangeForRenderUpdate_2_, int p_markBlockRangeForRenderUpdate_3_, int p_markBlockRangeForRenderUpdate_4_, int p_markBlockRangeForRenderUpdate_5_, int p_markBlockRangeForRenderUpdate_6_) {
    }

    @Override
    public void playSoundToAllNearExcept(EntityPlayer p_playSoundToAllNearExcept_1_, SoundEvent p_playSoundToAllNearExcept_2_, SoundCategory p_playSoundToAllNearExcept_3_, double p_playSoundToAllNearExcept_4_, double p_playSoundToAllNearExcept_6_, double p_playSoundToAllNearExcept_8_, float p_playSoundToAllNearExcept_10_, float p_playSoundToAllNearExcept_11_) {
    }

    @Override
    public void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, double p_spawnParticle_3_, double p_spawnParticle_5_, double p_spawnParticle_7_, double p_spawnParticle_9_, double p_spawnParticle_11_, double p_spawnParticle_13_, int ... p_spawnParticle_15_) {
    }

    @Override
    public void spawnParticle(int p_spawnParticle_1_, boolean p_spawnParticle_2_, boolean p_spawnParticle_3_, double p_spawnParticle_4_, double p_spawnParticle_6_, double p_spawnParticle_8_, double p_spawnParticle_10_, double p_spawnParticle_12_, double p_spawnParticle_14_, int ... p_spawnParticle_16_) {
    }

    @Override
    public void onEntityAdded(Entity p_onEntityAdded_1_) {
        if (p_onEntityAdded_1_ instanceof EntityLiving) {
            this.navigations.add(((EntityLiving)p_onEntityAdded_1_).getNavigator());
        }
    }

    @Override
    public void onEntityRemoved(Entity p_onEntityRemoved_1_) {
        if (p_onEntityRemoved_1_ instanceof EntityLiving) {
            this.navigations.remove(((EntityLiving)p_onEntityRemoved_1_).getNavigator());
        }
    }

    @Override
    public void playRecord(SoundEvent p_playRecord_1_, BlockPos p_playRecord_2_) {
    }

    @Override
    public void broadcastSound(int p_broadcastSound_1_, BlockPos p_broadcastSound_2_, int p_broadcastSound_3_) {
    }

    @Override
    public void playEvent(EntityPlayer p_playEvent_1_, int p_playEvent_2_, BlockPos p_playEvent_3_, int p_playEvent_4_) {
    }

    @Override
    public void sendBlockBreakProgress(int p_sendBlockBreakProgress_1_, BlockPos p_sendBlockBreakProgress_2_, int p_sendBlockBreakProgress_3_) {
    }
}

