/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class SwimNodeProcessor
extends NodeProcessor {
    @Override
    public PathPoint getStart() {
        return this.openPoint(MathHelper.floor(this.entity.getEntityBoundingBox().minX), MathHelper.floor(this.entity.getEntityBoundingBox().minY + 0.5), MathHelper.floor(this.entity.getEntityBoundingBox().minZ));
    }

    @Override
    public PathPoint getPathPointToCoords(double p_getPathPointToCoords_1_, double p_getPathPointToCoords_3_, double p_getPathPointToCoords_5_) {
        return this.openPoint(MathHelper.floor(p_getPathPointToCoords_1_ - (double)(this.entity.width / 2.0f)), MathHelper.floor(p_getPathPointToCoords_3_ + 0.5), MathHelper.floor(p_getPathPointToCoords_5_ - (double)(this.entity.width / 2.0f)));
    }

    @Override
    public int findPathOptions(PathPoint[] p_findPathOptions_1_, PathPoint p_findPathOptions_2_, PathPoint p_findPathOptions_3_, float p_findPathOptions_4_) {
        int lvt_5_1_ = 0;
        for (EnumFacing lvt_9_1_ : EnumFacing.values()) {
            PathPoint lvt_10_1_ = this.getWaterNode(p_findPathOptions_2_.xCoord + lvt_9_1_.getFrontOffsetX(), p_findPathOptions_2_.yCoord + lvt_9_1_.getFrontOffsetY(), p_findPathOptions_2_.zCoord + lvt_9_1_.getFrontOffsetZ());
            if (lvt_10_1_ == null || lvt_10_1_.visited || !(lvt_10_1_.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_)) continue;
            p_findPathOptions_1_[lvt_5_1_++] = lvt_10_1_;
        }
        return lvt_5_1_;
    }

    @Override
    public PathNodeType getPathNodeType(IBlockAccess p_getPathNodeType_1_, int p_getPathNodeType_2_, int p_getPathNodeType_3_, int p_getPathNodeType_4_, EntityLiving p_getPathNodeType_5_, int p_getPathNodeType_6_, int p_getPathNodeType_7_, int p_getPathNodeType_8_, boolean p_getPathNodeType_9_, boolean p_getPathNodeType_10_) {
        return PathNodeType.WATER;
    }

    @Override
    public PathNodeType getPathNodeType(IBlockAccess p_getPathNodeType_1_, int p_getPathNodeType_2_, int p_getPathNodeType_3_, int p_getPathNodeType_4_) {
        return PathNodeType.WATER;
    }

    @Nullable
    private PathPoint getWaterNode(int p_getWaterNode_1_, int p_getWaterNode_2_, int p_getWaterNode_3_) {
        PathNodeType lvt_4_1_ = this.isFree(p_getWaterNode_1_, p_getWaterNode_2_, p_getWaterNode_3_);
        if (lvt_4_1_ == PathNodeType.WATER) {
            return this.openPoint(p_getWaterNode_1_, p_getWaterNode_2_, p_getWaterNode_3_);
        }
        return null;
    }

    private PathNodeType isFree(int p_isFree_1_, int p_isFree_2_, int p_isFree_3_) {
        BlockPos.MutableBlockPos lvt_4_1_ = new BlockPos.MutableBlockPos();
        for (int lvt_5_1_ = p_isFree_1_; lvt_5_1_ < p_isFree_1_ + this.entitySizeX; ++lvt_5_1_) {
            for (int lvt_6_1_ = p_isFree_2_; lvt_6_1_ < p_isFree_2_ + this.entitySizeY; ++lvt_6_1_) {
                for (int lvt_7_1_ = p_isFree_3_; lvt_7_1_ < p_isFree_3_ + this.entitySizeZ; ++lvt_7_1_) {
                    IBlockState lvt_8_1_ = this.blockaccess.getBlockState(lvt_4_1_.setPos(lvt_5_1_, lvt_6_1_, lvt_7_1_));
                    if (lvt_8_1_.getMaterial() == Material.WATER) continue;
                    return PathNodeType.BLOCKED;
                }
            }
        }
        return PathNodeType.WATER;
    }
}

