/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.pathfinding;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class WalkNodeProcessor
extends NodeProcessor {
    private float avoidsWater;

    @Override
    public void initProcessor(IBlockAccess p_initProcessor_1_, EntityLiving p_initProcessor_2_) {
        super.initProcessor(p_initProcessor_1_, p_initProcessor_2_);
        this.avoidsWater = p_initProcessor_2_.getPathPriority(PathNodeType.WATER);
    }

    @Override
    public void postProcess() {
        this.entity.setPathPriority(PathNodeType.WATER, this.avoidsWater);
        super.postProcess();
    }

    @Override
    public PathPoint getStart() {
        int i;
        if (this.getCanSwim() && this.entity.isInWater()) {
            i = (int)this.entity.getEntityBoundingBox().minY;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(MathHelper.floor(this.entity.posX), i, MathHelper.floor(this.entity.posZ));
            Block block = this.blockaccess.getBlockState(blockpos$mutableblockpos).getBlock();
            while (block == Blocks.FLOWING_WATER || block == Blocks.WATER) {
                blockpos$mutableblockpos.setPos(MathHelper.floor(this.entity.posX), ++i, MathHelper.floor(this.entity.posZ));
                block = this.blockaccess.getBlockState(blockpos$mutableblockpos).getBlock();
            }
        } else if (this.entity.onGround) {
            i = MathHelper.floor(this.entity.getEntityBoundingBox().minY + 0.5);
        } else {
            BlockPos blockpos = new BlockPos(this.entity);
            while ((this.blockaccess.getBlockState(blockpos).getMaterial() == Material.AIR || this.blockaccess.getBlockState(blockpos).getBlock().isPassable(this.blockaccess, blockpos)) && blockpos.getY() > 0) {
                blockpos = blockpos.down();
            }
            i = blockpos.up().getY();
        }
        BlockPos blockpos2 = new BlockPos(this.entity);
        PathNodeType pathnodetype1 = this.getPathNodeType(this.entity, blockpos2.getX(), i, blockpos2.getZ());
        if (this.entity.getPathPriority(pathnodetype1) < 0.0f) {
            HashSet set = Sets.newHashSet();
            set.add(new BlockPos(this.entity.getEntityBoundingBox().minX, (double)i, this.entity.getEntityBoundingBox().minZ));
            set.add(new BlockPos(this.entity.getEntityBoundingBox().minX, (double)i, this.entity.getEntityBoundingBox().maxZ));
            set.add(new BlockPos(this.entity.getEntityBoundingBox().maxX, (double)i, this.entity.getEntityBoundingBox().minZ));
            set.add(new BlockPos(this.entity.getEntityBoundingBox().maxX, (double)i, this.entity.getEntityBoundingBox().maxZ));
            for (BlockPos blockpos1 : set) {
                PathNodeType pathnodetype = this.getPathNodeType(this.entity, blockpos1);
                if (!(this.entity.getPathPriority(pathnodetype) >= 0.0f)) continue;
                return this.openPoint(blockpos1.getX(), blockpos1.getY(), blockpos1.getZ());
            }
        }
        return this.openPoint(blockpos2.getX(), i, blockpos2.getZ());
    }

    @Override
    public PathPoint getPathPointToCoords(double p_getPathPointToCoords_1_, double p_getPathPointToCoords_3_, double p_getPathPointToCoords_5_) {
        return this.openPoint(MathHelper.floor(p_getPathPointToCoords_1_), MathHelper.floor(p_getPathPointToCoords_3_), MathHelper.floor(p_getPathPointToCoords_5_));
    }

    @Override
    public int findPathOptions(PathPoint[] p_findPathOptions_1_, PathPoint p_findPathOptions_2_, PathPoint p_findPathOptions_3_, float p_findPathOptions_4_) {
        PathPoint pathpoint7;
        PathPoint pathpoint6;
        PathPoint pathpoint5;
        PathPoint pathpoint4;
        boolean flag3;
        int i = 0;
        int j = 0;
        PathNodeType pathnodetype = this.getPathNodeType(this.entity, p_findPathOptions_2_.xCoord, p_findPathOptions_2_.yCoord + 1, p_findPathOptions_2_.zCoord);
        if (this.entity.getPathPriority(pathnodetype) >= 0.0f) {
            j = MathHelper.floor(Math.max(1.0f, this.entity.stepHeight));
        }
        BlockPos blockpos = new BlockPos(p_findPathOptions_2_.xCoord, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord).down();
        double d0 = (double)p_findPathOptions_2_.yCoord - (1.0 - this.blockaccess.getBlockState((BlockPos)blockpos).getBoundingBox((IBlockAccess)this.blockaccess, (BlockPos)blockpos).maxY);
        PathPoint pathpoint = this.getSafePoint(p_findPathOptions_2_.xCoord, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord + 1, j, d0, EnumFacing.SOUTH);
        PathPoint pathpoint1 = this.getSafePoint(p_findPathOptions_2_.xCoord - 1, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord, j, d0, EnumFacing.WEST);
        PathPoint pathpoint2 = this.getSafePoint(p_findPathOptions_2_.xCoord + 1, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord, j, d0, EnumFacing.EAST);
        PathPoint pathpoint3 = this.getSafePoint(p_findPathOptions_2_.xCoord, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord - 1, j, d0, EnumFacing.NORTH);
        if (pathpoint != null && !pathpoint.visited && pathpoint.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint;
        }
        if (pathpoint1 != null && !pathpoint1.visited && pathpoint1.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint1;
        }
        if (pathpoint2 != null && !pathpoint2.visited && pathpoint2.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint2;
        }
        if (pathpoint3 != null && !pathpoint3.visited && pathpoint3.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint3;
        }
        boolean flag = pathpoint3 == null || pathpoint3.nodeType == PathNodeType.OPEN || pathpoint3.costMalus != 0.0f;
        boolean flag1 = pathpoint == null || pathpoint.nodeType == PathNodeType.OPEN || pathpoint.costMalus != 0.0f;
        boolean flag2 = pathpoint2 == null || pathpoint2.nodeType == PathNodeType.OPEN || pathpoint2.costMalus != 0.0f;
        boolean bl = flag3 = pathpoint1 == null || pathpoint1.nodeType == PathNodeType.OPEN || pathpoint1.costMalus != 0.0f;
        if (flag && flag3 && (pathpoint4 = this.getSafePoint(p_findPathOptions_2_.xCoord - 1, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint4.visited && pathpoint4.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint4;
        }
        if (flag && flag2 && (pathpoint5 = this.getSafePoint(p_findPathOptions_2_.xCoord + 1, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord - 1, j, d0, EnumFacing.NORTH)) != null && !pathpoint5.visited && pathpoint5.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint5;
        }
        if (flag1 && flag3 && (pathpoint6 = this.getSafePoint(p_findPathOptions_2_.xCoord - 1, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint6.visited && pathpoint6.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint6;
        }
        if (flag1 && flag2 && (pathpoint7 = this.getSafePoint(p_findPathOptions_2_.xCoord + 1, p_findPathOptions_2_.yCoord, p_findPathOptions_2_.zCoord + 1, j, d0, EnumFacing.SOUTH)) != null && !pathpoint7.visited && pathpoint7.distanceTo(p_findPathOptions_3_) < p_findPathOptions_4_) {
            p_findPathOptions_1_[i++] = pathpoint7;
        }
        return i;
    }

    @Nullable
    private PathPoint getSafePoint(int p_getSafePoint_1_, int p_getSafePoint_2_, int p_getSafePoint_3_, int p_getSafePoint_4_, double p_getSafePoint_5_, EnumFacing p_getSafePoint_7_) {
        PathPoint pathpoint = null;
        BlockPos blockpos = new BlockPos(p_getSafePoint_1_, p_getSafePoint_2_, p_getSafePoint_3_);
        BlockPos blockpos1 = blockpos.down();
        double d0 = (double)p_getSafePoint_2_ - (1.0 - this.blockaccess.getBlockState((BlockPos)blockpos1).getBoundingBox((IBlockAccess)this.blockaccess, (BlockPos)blockpos1).maxY);
        if (d0 - p_getSafePoint_5_ > 1.125) {
            return null;
        }
        PathNodeType pathnodetype = this.getPathNodeType(this.entity, p_getSafePoint_1_, p_getSafePoint_2_, p_getSafePoint_3_);
        float f = this.entity.getPathPriority(pathnodetype);
        double d1 = (double)this.entity.width / 2.0;
        if (f >= 0.0f) {
            pathpoint = this.openPoint(p_getSafePoint_1_, p_getSafePoint_2_, p_getSafePoint_3_);
            pathpoint.nodeType = pathnodetype;
            pathpoint.costMalus = Math.max(pathpoint.costMalus, f);
        }
        if (pathnodetype == PathNodeType.WALKABLE) {
            return pathpoint;
        }
        if (pathpoint == null && p_getSafePoint_4_ > 0 && pathnodetype != PathNodeType.FENCE && pathnodetype != PathNodeType.TRAPDOOR && (pathpoint = this.getSafePoint(p_getSafePoint_1_, p_getSafePoint_2_ + 1, p_getSafePoint_3_, p_getSafePoint_4_ - 1, p_getSafePoint_5_, p_getSafePoint_7_)) != null && (pathpoint.nodeType == PathNodeType.OPEN || pathpoint.nodeType == PathNodeType.WALKABLE) && this.entity.width < 1.0f) {
            double d2 = (double)(p_getSafePoint_1_ - p_getSafePoint_7_.getFrontOffsetX()) + 0.5;
            double d3 = (double)(p_getSafePoint_3_ - p_getSafePoint_7_.getFrontOffsetZ()) + 0.5;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(d2 - d1, (double)p_getSafePoint_2_ + 0.001, d3 - d1, d2 + d1, (float)p_getSafePoint_2_ + this.entity.height, d3 + d1);
            AxisAlignedBB axisalignedbb1 = this.blockaccess.getBlockState(blockpos).getBoundingBox(this.blockaccess, blockpos);
            AxisAlignedBB axisalignedbb2 = axisalignedbb.addCoord(0.0, axisalignedbb1.maxY - 0.002, 0.0);
            if (this.entity.world.collidesWithAnyBlock(axisalignedbb2)) {
                pathpoint = null;
            }
        }
        if (pathnodetype == PathNodeType.OPEN) {
            PathNodeType pathnodetype1;
            AxisAlignedBB axisalignedbb3 = new AxisAlignedBB((double)p_getSafePoint_1_ - d1 + 0.5, (double)p_getSafePoint_2_ + 0.001, (double)p_getSafePoint_3_ - d1 + 0.5, (double)p_getSafePoint_1_ + d1 + 0.5, (float)p_getSafePoint_2_ + this.entity.height, (double)p_getSafePoint_3_ + d1 + 0.5);
            if (this.entity.world.collidesWithAnyBlock(axisalignedbb3)) {
                return null;
            }
            if (this.entity.width >= 1.0f && (pathnodetype1 = this.getPathNodeType(this.entity, p_getSafePoint_1_, p_getSafePoint_2_ - 1, p_getSafePoint_3_)) == PathNodeType.BLOCKED) {
                pathpoint = this.openPoint(p_getSafePoint_1_, p_getSafePoint_2_, p_getSafePoint_3_);
                pathpoint.nodeType = PathNodeType.WALKABLE;
                pathpoint.costMalus = Math.max(pathpoint.costMalus, f);
                return pathpoint;
            }
            int i = 0;
            while (p_getSafePoint_2_ > 0 && pathnodetype == PathNodeType.OPEN) {
                --p_getSafePoint_2_;
                if (i++ >= this.entity.getMaxFallHeight()) {
                    return null;
                }
                pathnodetype = this.getPathNodeType(this.entity, p_getSafePoint_1_, p_getSafePoint_2_, p_getSafePoint_3_);
                f = this.entity.getPathPriority(pathnodetype);
                if (pathnodetype != PathNodeType.OPEN && f >= 0.0f) {
                    pathpoint = this.openPoint(p_getSafePoint_1_, p_getSafePoint_2_, p_getSafePoint_3_);
                    pathpoint.nodeType = pathnodetype;
                    pathpoint.costMalus = Math.max(pathpoint.costMalus, f);
                    break;
                }
                if (!(f < 0.0f)) continue;
                return null;
            }
        }
        return pathpoint;
    }

    @Override
    public PathNodeType getPathNodeType(IBlockAccess p_getPathNodeType_1_, int p_getPathNodeType_2_, int p_getPathNodeType_3_, int p_getPathNodeType_4_, EntityLiving p_getPathNodeType_5_, int p_getPathNodeType_6_, int p_getPathNodeType_7_, int p_getPathNodeType_8_, boolean p_getPathNodeType_9_, boolean p_getPathNodeType_10_) {
        EnumSet<PathNodeType> enumset = EnumSet.noneOf(PathNodeType.class);
        PathNodeType pathnodetype = PathNodeType.BLOCKED;
        double d0 = (double)p_getPathNodeType_5_.width / 2.0;
        BlockPos blockpos = new BlockPos(p_getPathNodeType_5_);
        for (int i = 0; i < p_getPathNodeType_6_; ++i) {
            for (int j = 0; j < p_getPathNodeType_7_; ++j) {
                for (int k = 0; k < p_getPathNodeType_8_; ++k) {
                    int l = i + p_getPathNodeType_2_;
                    int i1 = j + p_getPathNodeType_3_;
                    int j1 = k + p_getPathNodeType_4_;
                    PathNodeType pathnodetype1 = this.getPathNodeType(p_getPathNodeType_1_, l, i1, j1);
                    if (pathnodetype1 == PathNodeType.DOOR_WOOD_CLOSED && p_getPathNodeType_9_ && p_getPathNodeType_10_) {
                        pathnodetype1 = PathNodeType.WALKABLE;
                    }
                    if (pathnodetype1 == PathNodeType.DOOR_OPEN && !p_getPathNodeType_10_) {
                        pathnodetype1 = PathNodeType.BLOCKED;
                    }
                    if (pathnodetype1 == PathNodeType.RAIL && !(p_getPathNodeType_1_.getBlockState(blockpos).getBlock() instanceof BlockRailBase) && !(p_getPathNodeType_1_.getBlockState(blockpos.down()).getBlock() instanceof BlockRailBase)) {
                        pathnodetype1 = PathNodeType.FENCE;
                    }
                    if (i == 0 && j == 0 && k == 0) {
                        pathnodetype = pathnodetype1;
                    }
                    enumset.add(pathnodetype1);
                }
            }
        }
        if (enumset.contains((Object)PathNodeType.FENCE)) {
            return PathNodeType.FENCE;
        }
        PathNodeType pathnodetype2 = PathNodeType.BLOCKED;
        for (PathNodeType pathnodetype3 : enumset) {
            if (p_getPathNodeType_5_.getPathPriority(pathnodetype3) < 0.0f) {
                return pathnodetype3;
            }
            if (!(p_getPathNodeType_5_.getPathPriority(pathnodetype3) >= p_getPathNodeType_5_.getPathPriority(pathnodetype2))) continue;
            pathnodetype2 = pathnodetype3;
        }
        if (pathnodetype == PathNodeType.OPEN && p_getPathNodeType_5_.getPathPriority(pathnodetype2) == 0.0f) {
            return PathNodeType.OPEN;
        }
        return pathnodetype2;
    }

    private PathNodeType getPathNodeType(EntityLiving p_getPathNodeType_1_, BlockPos p_getPathNodeType_2_) {
        return this.getPathNodeType(p_getPathNodeType_1_, p_getPathNodeType_2_.getX(), p_getPathNodeType_2_.getY(), p_getPathNodeType_2_.getZ());
    }

    private PathNodeType getPathNodeType(EntityLiving p_getPathNodeType_1_, int p_getPathNodeType_2_, int p_getPathNodeType_3_, int p_getPathNodeType_4_) {
        return this.getPathNodeType(this.blockaccess, p_getPathNodeType_2_, p_getPathNodeType_3_, p_getPathNodeType_4_, p_getPathNodeType_1_, this.entitySizeX, this.entitySizeY, this.entitySizeZ, this.getCanBreakDoors(), this.getCanEnterDoors());
    }

    @Override
    public PathNodeType getPathNodeType(IBlockAccess p_getPathNodeType_1_, int p_getPathNodeType_2_, int p_getPathNodeType_3_, int p_getPathNodeType_4_) {
        PathNodeType pathnodetype = this.getPathNodeTypeRaw(p_getPathNodeType_1_, p_getPathNodeType_2_, p_getPathNodeType_3_, p_getPathNodeType_4_);
        if (pathnodetype == PathNodeType.OPEN && p_getPathNodeType_3_ >= 1) {
            Block block = p_getPathNodeType_1_.getBlockState(new BlockPos(p_getPathNodeType_2_, p_getPathNodeType_3_ - 1, p_getPathNodeType_4_)).getBlock();
            PathNodeType pathnodetype1 = this.getPathNodeTypeRaw(p_getPathNodeType_1_, p_getPathNodeType_2_, p_getPathNodeType_3_ - 1, p_getPathNodeType_4_);
            PathNodeType pathNodeType = pathnodetype = pathnodetype1 != PathNodeType.WALKABLE && pathnodetype1 != PathNodeType.OPEN && pathnodetype1 != PathNodeType.WATER && pathnodetype1 != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
            if (pathnodetype1 == PathNodeType.DAMAGE_FIRE || block == Blocks.MAGMA) {
                pathnodetype = PathNodeType.DAMAGE_FIRE;
            }
            if (pathnodetype1 == PathNodeType.DAMAGE_CACTUS) {
                pathnodetype = PathNodeType.DAMAGE_CACTUS;
            }
        }
        BlockPos.PooledMutableBlockPos blockpos$pooledmutableblockpos = BlockPos.PooledMutableBlockPos.retain();
        if (pathnodetype == PathNodeType.WALKABLE) {
            for (int j = -1; j <= 1; ++j) {
                for (int i = -1; i <= 1; ++i) {
                    if (j == 0 && i == 0) continue;
                    Block block1 = p_getPathNodeType_1_.getBlockState(blockpos$pooledmutableblockpos.setPos(j + p_getPathNodeType_2_, p_getPathNodeType_3_, i + p_getPathNodeType_4_)).getBlock();
                    if (block1 == Blocks.CACTUS) {
                        pathnodetype = PathNodeType.DANGER_CACTUS;
                        continue;
                    }
                    if (block1 == Blocks.FIRE) {
                        pathnodetype = PathNodeType.DANGER_FIRE;
                        continue;
                    }
                    if (!block1.isBurning(p_getPathNodeType_1_, blockpos$pooledmutableblockpos.setPos(j + p_getPathNodeType_2_, p_getPathNodeType_3_, i + p_getPathNodeType_4_))) continue;
                    pathnodetype = PathNodeType.DAMAGE_FIRE;
                }
            }
        }
        blockpos$pooledmutableblockpos.release();
        return pathnodetype;
    }

    private PathNodeType getPathNodeTypeRaw(IBlockAccess p_getPathNodeTypeRaw_1_, int p_getPathNodeTypeRaw_2_, int p_getPathNodeTypeRaw_3_, int p_getPathNodeTypeRaw_4_) {
        BlockPos blockpos = new BlockPos(p_getPathNodeTypeRaw_2_, p_getPathNodeTypeRaw_3_, p_getPathNodeTypeRaw_4_);
        IBlockState iblockstate = p_getPathNodeTypeRaw_1_.getBlockState(blockpos);
        Block block = iblockstate.getBlock();
        Material material = iblockstate.getMaterial();
        PathNodeType type = block.getAiPathNodeType(iblockstate, p_getPathNodeTypeRaw_1_, blockpos);
        if (type != null) {
            return type;
        }
        return material == Material.AIR ? PathNodeType.OPEN : (block != Blocks.TRAPDOOR && block != Blocks.IRON_TRAPDOOR && block != Blocks.WATERLILY ? (block == Blocks.FIRE ? PathNodeType.DAMAGE_FIRE : (block == Blocks.CACTUS ? PathNodeType.DAMAGE_CACTUS : (block instanceof BlockDoor && material == Material.WOOD && !iblockstate.getValue(BlockDoor.OPEN).booleanValue() ? PathNodeType.DOOR_WOOD_CLOSED : (block instanceof BlockDoor && material == Material.IRON && !iblockstate.getValue(BlockDoor.OPEN).booleanValue() ? PathNodeType.DOOR_IRON_CLOSED : (block instanceof BlockDoor && iblockstate.getValue(BlockDoor.OPEN).booleanValue() ? PathNodeType.DOOR_OPEN : (block instanceof BlockRailBase ? PathNodeType.RAIL : (!(block instanceof BlockFence || block instanceof BlockWall || block instanceof BlockFenceGate && !iblockstate.getValue(BlockFenceGate.OPEN).booleanValue()) ? (material == Material.WATER ? PathNodeType.WATER : (material == Material.LAVA ? PathNodeType.LAVA : (block.isPassable(p_getPathNodeTypeRaw_1_, blockpos) ? PathNodeType.OPEN : PathNodeType.BLOCKED))) : PathNodeType.FENCE))))))) : PathNodeType.TRAPDOOR);
    }
}

