/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PotionEffect
implements Comparable<PotionEffect> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Potion potion;
    private int duration;
    private int amplifier;
    private boolean isSplashPotion;
    private boolean isAmbient;
    @SideOnly(value=Side.CLIENT)
    private boolean isPotionDurationMax;
    private boolean showParticles;
    private List<ItemStack> curativeItems;

    public PotionEffect(Potion p_i46811_1_) {
        this(p_i46811_1_, 0, 0);
    }

    public PotionEffect(Potion p_i46812_1_, int p_i46812_2_) {
        this(p_i46812_1_, p_i46812_2_, 0);
    }

    public PotionEffect(Potion p_i46813_1_, int p_i46813_2_, int p_i46813_3_) {
        this(p_i46813_1_, p_i46813_2_, p_i46813_3_, false, true);
    }

    public PotionEffect(Potion p_i46814_1_, int p_i46814_2_, int p_i46814_3_, boolean p_i46814_4_, boolean p_i46814_5_) {
        this.potion = p_i46814_1_;
        this.duration = p_i46814_2_;
        this.amplifier = p_i46814_3_;
        this.isAmbient = p_i46814_4_;
        this.showParticles = p_i46814_5_;
    }

    public PotionEffect(PotionEffect p_i1577_1_) {
        this.potion = p_i1577_1_.potion;
        this.duration = p_i1577_1_.duration;
        this.amplifier = p_i1577_1_.amplifier;
        this.isAmbient = p_i1577_1_.isAmbient;
        this.showParticles = p_i1577_1_.showParticles;
        this.curativeItems = p_i1577_1_.curativeItems;
    }

    public void combine(PotionEffect p_combine_1_) {
        if (this.potion != p_combine_1_.potion) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        if (p_combine_1_.amplifier > this.amplifier) {
            this.amplifier = p_combine_1_.amplifier;
            this.duration = p_combine_1_.duration;
        } else if (p_combine_1_.amplifier == this.amplifier && this.duration < p_combine_1_.duration) {
            this.duration = p_combine_1_.duration;
        } else if (!p_combine_1_.isAmbient && this.isAmbient) {
            this.isAmbient = p_combine_1_.isAmbient;
        }
        this.showParticles = p_combine_1_.showParticles;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean getIsAmbient() {
        return this.isAmbient;
    }

    public boolean doesShowParticles() {
        return this.showParticles;
    }

    public boolean onUpdate(EntityLivingBase p_onUpdate_1_) {
        if (this.duration > 0) {
            if (this.potion.isReady(this.duration, this.amplifier)) {
                this.performEffect(p_onUpdate_1_);
            }
            this.deincrementDuration();
        }
        return this.duration > 0;
    }

    private int deincrementDuration() {
        return --this.duration;
    }

    public void performEffect(EntityLivingBase p_performEffect_1_) {
        if (this.duration > 0) {
            this.potion.performEffect(p_performEffect_1_, this.amplifier);
        }
    }

    public String getEffectName() {
        return this.potion.getName();
    }

    public String toString() {
        String s = this.amplifier > 0 ? this.getEffectName() + " x " + (this.amplifier + 1) + ", Duration: " + this.duration : this.getEffectName() + ", Duration: " + this.duration;
        if (this.isSplashPotion) {
            s = s + ", Splash: true";
        }
        if (!this.showParticles) {
            s = s + ", Particles: false";
        }
        return s;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof PotionEffect)) {
            return false;
        }
        PotionEffect potioneffect = (PotionEffect)p_equals_1_;
        return this.duration == potioneffect.duration && this.amplifier == potioneffect.amplifier && this.isSplashPotion == potioneffect.isSplashPotion && this.isAmbient == potioneffect.isAmbient && this.potion.equals(potioneffect.potion);
    }

    public int hashCode() {
        int i = this.potion.hashCode();
        i = 31 * i + this.duration;
        i = 31 * i + this.amplifier;
        i = 31 * i + (this.isSplashPotion ? 1 : 0);
        i = 31 * i + (this.isAmbient ? 1 : 0);
        return i;
    }

    public NBTTagCompound writeCustomPotionEffectToNBT(NBTTagCompound p_writeCustomPotionEffectToNBT_1_) {
        p_writeCustomPotionEffectToNBT_1_.setByte("Id", (byte)Potion.getIdFromPotion(this.getPotion()));
        p_writeCustomPotionEffectToNBT_1_.setByte("Amplifier", (byte)this.getAmplifier());
        p_writeCustomPotionEffectToNBT_1_.setInteger("Duration", this.getDuration());
        p_writeCustomPotionEffectToNBT_1_.setBoolean("Ambient", this.getIsAmbient());
        p_writeCustomPotionEffectToNBT_1_.setBoolean("ShowParticles", this.doesShowParticles());
        return p_writeCustomPotionEffectToNBT_1_;
    }

    public static PotionEffect readCustomPotionEffectFromNBT(NBTTagCompound p_readCustomPotionEffectFromNBT_0_) {
        int i = p_readCustomPotionEffectFromNBT_0_.getByte("Id") & 0xFF;
        Potion potion = Potion.getPotionById(i);
        if (potion == null) {
            return null;
        }
        byte j = p_readCustomPotionEffectFromNBT_0_.getByte("Amplifier");
        int k = p_readCustomPotionEffectFromNBT_0_.getInteger("Duration");
        boolean flag = p_readCustomPotionEffectFromNBT_0_.getBoolean("Ambient");
        boolean flag1 = true;
        if (p_readCustomPotionEffectFromNBT_0_.hasKey("ShowParticles", 1)) {
            flag1 = p_readCustomPotionEffectFromNBT_0_.getBoolean("ShowParticles");
        }
        return new PotionEffect(potion, k, j < 0 ? (byte)0 : j, flag, flag1);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPotionDurationMax(boolean p_setPotionDurationMax_1_) {
        this.isPotionDurationMax = p_setPotionDurationMax_1_;
    }

    @Override
    public int compareTo(PotionEffect p_compareTo_1_) {
        int i = 32147;
        return !(this.getDuration() > 32147 && p_compareTo_1_.getDuration() > 32147 || this.getIsAmbient() && p_compareTo_1_.getIsAmbient()) ? ComparisonChain.start().compare((Comparable)Boolean.valueOf(this.getIsAmbient()), (Comparable)Boolean.valueOf(p_compareTo_1_.getIsAmbient())).compare(this.getDuration(), p_compareTo_1_.getDuration()).compare(this.getPotion().getLiquidColor(), p_compareTo_1_.getPotion().getLiquidColor()).result() : ComparisonChain.start().compare((Comparable)Boolean.valueOf(this.getIsAmbient()), (Comparable)Boolean.valueOf(p_compareTo_1_.getIsAmbient())).compare(this.getPotion().getLiquidColor(), p_compareTo_1_.getPotion().getLiquidColor()).result();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getIsPotionDurationMax() {
        return this.isPotionDurationMax;
    }

    public List<ItemStack> getCurativeItems() {
        if (this.curativeItems == null) {
            this.curativeItems = new ArrayList<ItemStack>();
            this.curativeItems.add(new ItemStack(Items.MILK_BUCKET));
        }
        return this.curativeItems;
    }

    public boolean isCurativeItem(ItemStack p_isCurativeItem_1_) {
        for (ItemStack curativeItem : this.getCurativeItems()) {
            if (!curativeItem.isItemEqual(p_isCurativeItem_1_)) continue;
            return true;
        }
        return false;
    }

    public void setCurativeItems(List<ItemStack> p_setCurativeItems_1_) {
        this.curativeItems = p_setCurativeItems_1_;
    }

    public void addCurativeItem(ItemStack p_addCurativeItem_1_) {
        if (!this.isCurativeItem(p_addCurativeItem_1_)) {
            this.getCurativeItems().add(p_addCurativeItem_1_);
        }
    }
}

