/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;

public class PotionHelper {
    private static final List<MixPredicate<PotionType>> POTION_TYPE_CONVERSIONS = Lists.newArrayList();
    private static final List<MixPredicate<Item>> POTION_ITEM_CONVERSIONS = Lists.newArrayList();
    private static final List<ItemPredicateInstance> POTION_ITEMS = Lists.newArrayList();
    private static final Predicate<ItemStack> IS_POTION_ITEM = new Predicate<ItemStack>(){

        public boolean apply(ItemStack p_apply_1_) {
            for (ItemPredicateInstance lvt_3_1_ : POTION_ITEMS) {
                if (!lvt_3_1_.apply(p_apply_1_)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((ItemStack)p_apply_1_);
        }
    };

    public static boolean isReagent(ItemStack p_isReagent_0_) {
        return PotionHelper.isItemConversionReagent(p_isReagent_0_) || PotionHelper.isTypeConversionReagent(p_isReagent_0_);
    }

    protected static boolean isItemConversionReagent(ItemStack p_isItemConversionReagent_0_) {
        int lvt_2_1_ = POTION_ITEM_CONVERSIONS.size();
        for (int lvt_1_1_ = 0; lvt_1_1_ < lvt_2_1_; ++lvt_1_1_) {
            if (!PotionHelper.POTION_ITEM_CONVERSIONS.get((int)lvt_1_1_).reagent.apply((Object)p_isItemConversionReagent_0_)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isTypeConversionReagent(ItemStack p_isTypeConversionReagent_0_) {
        int lvt_2_1_ = POTION_TYPE_CONVERSIONS.size();
        for (int lvt_1_1_ = 0; lvt_1_1_ < lvt_2_1_; ++lvt_1_1_) {
            if (!PotionHelper.POTION_TYPE_CONVERSIONS.get((int)lvt_1_1_).reagent.apply((Object)p_isTypeConversionReagent_0_)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasConversions(ItemStack p_hasConversions_0_, ItemStack p_hasConversions_1_) {
        if (!IS_POTION_ITEM.apply((Object)p_hasConversions_0_)) {
            return false;
        }
        return PotionHelper.hasItemConversions(p_hasConversions_0_, p_hasConversions_1_) || PotionHelper.hasTypeConversions(p_hasConversions_0_, p_hasConversions_1_);
    }

    protected static boolean hasItemConversions(ItemStack p_hasItemConversions_0_, ItemStack p_hasItemConversions_1_) {
        Item lvt_2_1_ = p_hasItemConversions_0_.getItem();
        int lvt_4_1_ = POTION_ITEM_CONVERSIONS.size();
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_4_1_; ++lvt_3_1_) {
            MixPredicate<Item> lvt_5_1_ = POTION_ITEM_CONVERSIONS.get(lvt_3_1_);
            if (lvt_5_1_.input != lvt_2_1_ || !lvt_5_1_.reagent.apply((Object)p_hasItemConversions_1_)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasTypeConversions(ItemStack p_hasTypeConversions_0_, ItemStack p_hasTypeConversions_1_) {
        PotionType lvt_2_1_ = PotionUtils.getPotionFromItem(p_hasTypeConversions_0_);
        int lvt_4_1_ = POTION_TYPE_CONVERSIONS.size();
        for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_4_1_; ++lvt_3_1_) {
            MixPredicate<PotionType> lvt_5_1_ = POTION_TYPE_CONVERSIONS.get(lvt_3_1_);
            if (lvt_5_1_.input != lvt_2_1_ || !lvt_5_1_.reagent.apply((Object)p_hasTypeConversions_1_)) continue;
            return true;
        }
        return false;
    }

    public static ItemStack doReaction(ItemStack p_doReaction_0_, ItemStack p_doReaction_1_) {
        if (!p_doReaction_1_.isEmpty()) {
            PotionType lvt_2_1_ = PotionUtils.getPotionFromItem(p_doReaction_1_);
            Item lvt_3_1_ = p_doReaction_1_.getItem();
            int lvt_5_1_ = POTION_ITEM_CONVERSIONS.size();
            for (int lvt_4_1_ = 0; lvt_4_1_ < lvt_5_1_; ++lvt_4_1_) {
                MixPredicate<Item> lvt_6_1_ = POTION_ITEM_CONVERSIONS.get(lvt_4_1_);
                if (lvt_6_1_.input != lvt_3_1_ || !lvt_6_1_.reagent.apply((Object)p_doReaction_0_)) continue;
                return PotionUtils.addPotionToItemStack(new ItemStack((Item)lvt_6_1_.output), lvt_2_1_);
            }
            int lvt_5_2_ = POTION_TYPE_CONVERSIONS.size();
            for (int lvt_4_2_ = 0; lvt_4_2_ < lvt_5_2_; ++lvt_4_2_) {
                MixPredicate<PotionType> lvt_6_2_ = POTION_TYPE_CONVERSIONS.get(lvt_4_2_);
                if (lvt_6_2_.input != lvt_2_1_ || !lvt_6_2_.reagent.apply((Object)p_doReaction_0_)) continue;
                return PotionUtils.addPotionToItemStack(new ItemStack(lvt_3_1_), (PotionType)lvt_6_2_.output);
            }
        }
        return p_doReaction_1_;
    }

    public static void init() {
        ItemPredicateInstance lvt_0_1_ = new ItemPredicateInstance(Items.NETHER_WART);
        ItemPredicateInstance lvt_1_1_ = new ItemPredicateInstance(Items.GOLDEN_CARROT);
        ItemPredicateInstance lvt_2_1_ = new ItemPredicateInstance(Items.REDSTONE);
        ItemPredicateInstance lvt_3_1_ = new ItemPredicateInstance(Items.FERMENTED_SPIDER_EYE);
        ItemPredicateInstance lvt_4_1_ = new ItemPredicateInstance(Items.RABBIT_FOOT);
        ItemPredicateInstance lvt_5_1_ = new ItemPredicateInstance(Items.GLOWSTONE_DUST);
        ItemPredicateInstance lvt_6_1_ = new ItemPredicateInstance(Items.MAGMA_CREAM);
        ItemPredicateInstance lvt_7_1_ = new ItemPredicateInstance(Items.SUGAR);
        ItemPredicateInstance lvt_8_1_ = new ItemPredicateInstance(Items.FISH, ItemFishFood.FishType.PUFFERFISH.getMetadata());
        ItemPredicateInstance lvt_9_1_ = new ItemPredicateInstance(Items.SPECKLED_MELON);
        ItemPredicateInstance lvt_10_1_ = new ItemPredicateInstance(Items.SPIDER_EYE);
        ItemPredicateInstance lvt_11_1_ = new ItemPredicateInstance(Items.GHAST_TEAR);
        ItemPredicateInstance lvt_12_1_ = new ItemPredicateInstance(Items.BLAZE_POWDER);
        PotionHelper.registerPotionItem(new ItemPredicateInstance(Items.POTIONITEM));
        PotionHelper.registerPotionItem(new ItemPredicateInstance(Items.SPLASH_POTION));
        PotionHelper.registerPotionItem(new ItemPredicateInstance(Items.LINGERING_POTION));
        PotionHelper.registerPotionItemConversion(Items.POTIONITEM, new ItemPredicateInstance(Items.GUNPOWDER), Items.SPLASH_POTION);
        PotionHelper.registerPotionItemConversion(Items.SPLASH_POTION, new ItemPredicateInstance(Items.DRAGON_BREATH), Items.LINGERING_POTION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_9_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_11_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_4_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_12_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_10_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_7_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_6_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_5_1_, PotionTypes.THICK);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_2_1_, PotionTypes.MUNDANE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_0_1_, PotionTypes.AWKWARD);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_1_1_, PotionTypes.NIGHT_VISION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.NIGHT_VISION, lvt_2_1_, PotionTypes.LONG_NIGHT_VISION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.NIGHT_VISION, lvt_3_1_, PotionTypes.INVISIBILITY);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_NIGHT_VISION, lvt_3_1_, PotionTypes.LONG_INVISIBILITY);
        PotionHelper.registerPotionTypeConversion(PotionTypes.INVISIBILITY, lvt_2_1_, PotionTypes.LONG_INVISIBILITY);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_6_1_, PotionTypes.FIRE_RESISTANCE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.FIRE_RESISTANCE, lvt_2_1_, PotionTypes.LONG_FIRE_RESISTANCE);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_4_1_, PotionTypes.LEAPING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LEAPING, lvt_2_1_, PotionTypes.LONG_LEAPING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LEAPING, lvt_5_1_, PotionTypes.STRONG_LEAPING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LEAPING, lvt_3_1_, PotionTypes.SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_LEAPING, lvt_3_1_, PotionTypes.LONG_SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SLOWNESS, lvt_2_1_, PotionTypes.LONG_SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SWIFTNESS, lvt_3_1_, PotionTypes.SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_SWIFTNESS, lvt_3_1_, PotionTypes.LONG_SLOWNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_7_1_, PotionTypes.SWIFTNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SWIFTNESS, lvt_2_1_, PotionTypes.LONG_SWIFTNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.SWIFTNESS, lvt_5_1_, PotionTypes.STRONG_SWIFTNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_8_1_, PotionTypes.WATER_BREATHING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER_BREATHING, lvt_2_1_, PotionTypes.LONG_WATER_BREATHING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_9_1_, PotionTypes.HEALING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.HEALING, lvt_5_1_, PotionTypes.STRONG_HEALING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.HEALING, lvt_3_1_, PotionTypes.HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRONG_HEALING, lvt_3_1_, PotionTypes.STRONG_HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.HARMING, lvt_5_1_, PotionTypes.STRONG_HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.POISON, lvt_3_1_, PotionTypes.HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.LONG_POISON, lvt_3_1_, PotionTypes.HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRONG_POISON, lvt_3_1_, PotionTypes.STRONG_HARMING);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_10_1_, PotionTypes.POISON);
        PotionHelper.registerPotionTypeConversion(PotionTypes.POISON, lvt_2_1_, PotionTypes.LONG_POISON);
        PotionHelper.registerPotionTypeConversion(PotionTypes.POISON, lvt_5_1_, PotionTypes.STRONG_POISON);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_11_1_, PotionTypes.REGENERATION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.REGENERATION, lvt_2_1_, PotionTypes.LONG_REGENERATION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.REGENERATION, lvt_5_1_, PotionTypes.STRONG_REGENERATION);
        PotionHelper.registerPotionTypeConversion(PotionTypes.AWKWARD, lvt_12_1_, PotionTypes.STRENGTH);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRENGTH, lvt_2_1_, PotionTypes.LONG_STRENGTH);
        PotionHelper.registerPotionTypeConversion(PotionTypes.STRENGTH, lvt_5_1_, PotionTypes.STRONG_STRENGTH);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WATER, lvt_3_1_, PotionTypes.WEAKNESS);
        PotionHelper.registerPotionTypeConversion(PotionTypes.WEAKNESS, lvt_2_1_, PotionTypes.LONG_WEAKNESS);
    }

    public static void registerPotionItemConversion(ItemPotion p_registerPotionItemConversion_0_, ItemPredicateInstance p_registerPotionItemConversion_1_, ItemPotion p_registerPotionItemConversion_2_) {
        POTION_ITEM_CONVERSIONS.add(new MixPredicate<ItemPotion>(p_registerPotionItemConversion_0_, p_registerPotionItemConversion_1_, p_registerPotionItemConversion_2_));
    }

    public static void registerPotionItem(ItemPredicateInstance p_registerPotionItem_0_) {
        POTION_ITEMS.add(p_registerPotionItem_0_);
    }

    public static void registerPotionTypeConversion(PotionType p_registerPotionTypeConversion_0_, Predicate<ItemStack> p_registerPotionTypeConversion_1_, PotionType p_registerPotionTypeConversion_2_) {
        POTION_TYPE_CONVERSIONS.add(new MixPredicate<PotionType>(p_registerPotionTypeConversion_0_, p_registerPotionTypeConversion_1_, p_registerPotionTypeConversion_2_));
    }

    public static class ItemPredicateInstance
    implements Predicate<ItemStack> {
        private final Item item;
        private final int meta;

        public ItemPredicateInstance(Item p_i47013_1_) {
            this(p_i47013_1_, -1);
        }

        public ItemPredicateInstance(Item p_i47014_1_, int p_i47014_2_) {
            this.item = p_i47014_1_;
            this.meta = p_i47014_2_;
        }

        public boolean apply(ItemStack p_apply_1_) {
            return p_apply_1_.getItem() == this.item && (this.meta == -1 || this.meta == p_apply_1_.getMetadata());
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((ItemStack)p_apply_1_);
        }
    }

    public static class MixPredicate<T> {
        final T input;
        final Predicate<ItemStack> reagent;
        final T output;

        public MixPredicate(T p_i47012_1_, Predicate<ItemStack> p_i47012_2_, T p_i47012_3_) {
            this.input = p_i47012_1_;
            this.reagent = p_i47012_2_;
            this.output = p_i47012_3_;
        }
    }
}

