/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.potion;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PotionUtils {
    public static List<PotionEffect> getEffectsFromStack(ItemStack p_getEffectsFromStack_0_) {
        return PotionUtils.getEffectsFromTag(p_getEffectsFromStack_0_.getTagCompound());
    }

    public static List<PotionEffect> mergeEffects(PotionType p_mergeEffects_0_, Collection<PotionEffect> p_mergeEffects_1_) {
        ArrayList lvt_2_1_ = Lists.newArrayList();
        lvt_2_1_.addAll(p_mergeEffects_0_.getEffects());
        lvt_2_1_.addAll(p_mergeEffects_1_);
        return lvt_2_1_;
    }

    public static List<PotionEffect> getEffectsFromTag(NBTTagCompound p_getEffectsFromTag_0_) {
        ArrayList lvt_1_1_ = Lists.newArrayList();
        lvt_1_1_.addAll(PotionUtils.getPotionTypeFromNBT(p_getEffectsFromTag_0_).getEffects());
        PotionUtils.addCustomPotionEffectToList(p_getEffectsFromTag_0_, lvt_1_1_);
        return lvt_1_1_;
    }

    public static List<PotionEffect> getFullEffectsFromItem(ItemStack p_getFullEffectsFromItem_0_) {
        return PotionUtils.getFullEffectsFromTag(p_getFullEffectsFromItem_0_.getTagCompound());
    }

    public static List<PotionEffect> getFullEffectsFromTag(NBTTagCompound p_getFullEffectsFromTag_0_) {
        ArrayList lvt_1_1_ = Lists.newArrayList();
        PotionUtils.addCustomPotionEffectToList(p_getFullEffectsFromTag_0_, lvt_1_1_);
        return lvt_1_1_;
    }

    public static void addCustomPotionEffectToList(NBTTagCompound p_addCustomPotionEffectToList_0_, List<PotionEffect> p_addCustomPotionEffectToList_1_) {
        if (p_addCustomPotionEffectToList_0_ != null && p_addCustomPotionEffectToList_0_.hasKey("CustomPotionEffects", 9)) {
            NBTTagList lvt_2_1_ = p_addCustomPotionEffectToList_0_.getTagList("CustomPotionEffects", 10);
            for (int lvt_3_1_ = 0; lvt_3_1_ < lvt_2_1_.tagCount(); ++lvt_3_1_) {
                NBTTagCompound lvt_4_1_ = lvt_2_1_.getCompoundTagAt(lvt_3_1_);
                PotionEffect lvt_5_1_ = PotionEffect.readCustomPotionEffectFromNBT(lvt_4_1_);
                if (lvt_5_1_ == null) continue;
                p_addCustomPotionEffectToList_1_.add(lvt_5_1_);
            }
        }
    }

    public static int getColor(ItemStack p_getColor_0_) {
        NBTTagCompound lvt_1_1_ = p_getColor_0_.getTagCompound();
        if (lvt_1_1_ != null && lvt_1_1_.hasKey("CustomPotionColor", 99)) {
            return lvt_1_1_.getInteger("CustomPotionColor");
        }
        return PotionUtils.getPotionFromItem(p_getColor_0_) == PotionTypes.EMPTY ? 0xF800F8 : PotionUtils.getPotionColorFromEffectList(PotionUtils.getEffectsFromStack(p_getColor_0_));
    }

    public static int getPotionColor(PotionType p_getPotionColor_0_) {
        return p_getPotionColor_0_ == PotionTypes.EMPTY ? 0xF800F8 : PotionUtils.getPotionColorFromEffectList(p_getPotionColor_0_.getEffects());
    }

    public static int getPotionColorFromEffectList(Collection<PotionEffect> p_getPotionColorFromEffectList_0_) {
        int lvt_1_1_ = 3694022;
        if (p_getPotionColorFromEffectList_0_.isEmpty()) {
            return 3694022;
        }
        float lvt_2_1_ = 0.0f;
        float lvt_3_1_ = 0.0f;
        float lvt_4_1_ = 0.0f;
        int lvt_5_1_ = 0;
        for (PotionEffect lvt_7_1_ : p_getPotionColorFromEffectList_0_) {
            if (!lvt_7_1_.doesShowParticles()) continue;
            int lvt_8_1_ = lvt_7_1_.getPotion().getLiquidColor();
            int lvt_9_1_ = lvt_7_1_.getAmplifier() + 1;
            lvt_2_1_ += (float)(lvt_9_1_ * (lvt_8_1_ >> 16 & 0xFF)) / 255.0f;
            lvt_3_1_ += (float)(lvt_9_1_ * (lvt_8_1_ >> 8 & 0xFF)) / 255.0f;
            lvt_4_1_ += (float)(lvt_9_1_ * (lvt_8_1_ >> 0 & 0xFF)) / 255.0f;
            lvt_5_1_ += lvt_9_1_;
        }
        if (lvt_5_1_ == 0) {
            return 0;
        }
        lvt_2_1_ = lvt_2_1_ / (float)lvt_5_1_ * 255.0f;
        lvt_3_1_ = lvt_3_1_ / (float)lvt_5_1_ * 255.0f;
        lvt_4_1_ = lvt_4_1_ / (float)lvt_5_1_ * 255.0f;
        return (int)lvt_2_1_ << 16 | (int)lvt_3_1_ << 8 | (int)lvt_4_1_;
    }

    public static PotionType getPotionFromItem(ItemStack p_getPotionFromItem_0_) {
        return PotionUtils.getPotionTypeFromNBT(p_getPotionFromItem_0_.getTagCompound());
    }

    public static PotionType getPotionTypeFromNBT(NBTTagCompound p_getPotionTypeFromNBT_0_) {
        if (p_getPotionTypeFromNBT_0_ == null) {
            return PotionTypes.EMPTY;
        }
        return PotionType.getPotionTypeForName(p_getPotionTypeFromNBT_0_.getString("Potion"));
    }

    public static ItemStack addPotionToItemStack(ItemStack p_addPotionToItemStack_0_, PotionType p_addPotionToItemStack_1_) {
        ResourceLocation lvt_2_1_ = PotionType.REGISTRY.getNameForObject(p_addPotionToItemStack_1_);
        if (p_addPotionToItemStack_1_ == PotionTypes.EMPTY) {
            if (p_addPotionToItemStack_0_.hasTagCompound()) {
                NBTTagCompound lvt_3_1_ = p_addPotionToItemStack_0_.getTagCompound();
                lvt_3_1_.removeTag("Potion");
                if (lvt_3_1_.hasNoTags()) {
                    p_addPotionToItemStack_0_.setTagCompound(null);
                }
            }
        } else {
            NBTTagCompound lvt_3_2_ = p_addPotionToItemStack_0_.hasTagCompound() ? p_addPotionToItemStack_0_.getTagCompound() : new NBTTagCompound();
            lvt_3_2_.setString("Potion", lvt_2_1_.toString());
            p_addPotionToItemStack_0_.setTagCompound(lvt_3_2_);
        }
        return p_addPotionToItemStack_0_;
    }

    public static ItemStack appendEffects(ItemStack p_appendEffects_0_, Collection<PotionEffect> p_appendEffects_1_) {
        if (p_appendEffects_1_.isEmpty()) {
            return p_appendEffects_0_;
        }
        NBTTagCompound lvt_2_1_ = (NBTTagCompound)Objects.firstNonNull((Object)p_appendEffects_0_.getTagCompound(), (Object)new NBTTagCompound());
        NBTTagList lvt_3_1_ = lvt_2_1_.getTagList("CustomPotionEffects", 9);
        for (PotionEffect lvt_5_1_ : p_appendEffects_1_) {
            lvt_3_1_.appendTag(lvt_5_1_.writeCustomPotionEffectToNBT(new NBTTagCompound()));
        }
        lvt_2_1_.setTag("CustomPotionEffects", lvt_3_1_);
        p_appendEffects_0_.setTagCompound(lvt_2_1_);
        return p_appendEffects_0_;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addPotionTooltip(ItemStack p_addPotionTooltip_0_, List<String> p_addPotionTooltip_1_, float p_addPotionTooltip_2_) {
        List<PotionEffect> lvt_3_1_ = PotionUtils.getEffectsFromStack(p_addPotionTooltip_0_);
        ArrayList lvt_4_1_ = Lists.newArrayList();
        if (lvt_3_1_.isEmpty()) {
            String lvt_5_1_ = I18n.translateToLocal("effect.none").trim();
            p_addPotionTooltip_1_.add((Object)((Object)TextFormatting.GRAY) + lvt_5_1_);
        } else {
            for (PotionEffect lvt_6_1_ : lvt_3_1_) {
                String lvt_7_1_ = I18n.translateToLocal(lvt_6_1_.getEffectName()).trim();
                Potion lvt_8_1_ = lvt_6_1_.getPotion();
                Map<IAttribute, AttributeModifier> lvt_9_1_ = lvt_8_1_.getAttributeModifierMap();
                if (!lvt_9_1_.isEmpty()) {
                    for (Map.Entry<IAttribute, AttributeModifier> lvt_11_1_ : lvt_9_1_.entrySet()) {
                        AttributeModifier lvt_12_1_ = lvt_11_1_.getValue();
                        AttributeModifier lvt_13_1_ = new AttributeModifier(lvt_12_1_.getName(), lvt_8_1_.getAttributeModifierAmount(lvt_6_1_.getAmplifier(), lvt_12_1_), lvt_12_1_.getOperation());
                        lvt_4_1_.add(new Tuple<String, AttributeModifier>(lvt_11_1_.getKey().getName(), lvt_13_1_));
                    }
                }
                if (lvt_6_1_.getAmplifier() > 0) {
                    lvt_7_1_ = lvt_7_1_ + " " + I18n.translateToLocal("potion.potency." + lvt_6_1_.getAmplifier()).trim();
                }
                if (lvt_6_1_.getDuration() > 20) {
                    lvt_7_1_ = lvt_7_1_ + " (" + Potion.getPotionDurationString(lvt_6_1_, p_addPotionTooltip_2_) + ")";
                }
                if (lvt_8_1_.isBadEffect()) {
                    p_addPotionTooltip_1_.add((Object)((Object)TextFormatting.RED) + lvt_7_1_);
                    continue;
                }
                p_addPotionTooltip_1_.add((Object)((Object)TextFormatting.BLUE) + lvt_7_1_);
            }
        }
        if (!lvt_4_1_.isEmpty()) {
            p_addPotionTooltip_1_.add("");
            p_addPotionTooltip_1_.add((Object)((Object)TextFormatting.DARK_PURPLE) + I18n.translateToLocal("potion.whenDrank"));
            for (Tuple lvt_6_2_ : lvt_4_1_) {
                double lvt_10_2_;
                AttributeModifier lvt_7_2_ = (AttributeModifier)lvt_6_2_.getSecond();
                double lvt_8_2_ = lvt_7_2_.getAmount();
                if (lvt_7_2_.getOperation() == 1 || lvt_7_2_.getOperation() == 2) {
                    double lvt_10_1_ = lvt_7_2_.getAmount() * 100.0;
                } else {
                    lvt_10_2_ = lvt_7_2_.getAmount();
                }
                if (lvt_8_2_ > 0.0) {
                    p_addPotionTooltip_1_.add((Object)((Object)TextFormatting.BLUE) + I18n.translateToLocalFormatted("attribute.modifier.plus." + lvt_7_2_.getOperation(), ItemStack.DECIMALFORMAT.format(lvt_10_2_), I18n.translateToLocal("attribute.name." + (String)lvt_6_2_.getFirst())));
                    continue;
                }
                if (!(lvt_8_2_ < 0.0)) continue;
                p_addPotionTooltip_1_.add((Object)((Object)TextFormatting.RED) + I18n.translateToLocalFormatted("attribute.modifier.take." + lvt_7_2_.getOperation(), ItemStack.DECIMALFORMAT.format(lvt_10_2_ *= -1.0), I18n.translateToLocal("attribute.name." + (String)lvt_6_2_.getFirst())));
            }
        }
    }
}

