/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.HttpUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Snooper {
    private final Map<String, Object> snooperStats = Maps.newHashMap();
    private final Map<String, Object> clientStats = Maps.newHashMap();
    private final String uniqueID = UUID.randomUUID().toString();
    private final URL serverUrl;
    private final ISnooperInfo playerStatsCollector;
    private final Timer threadTrigger = new Timer("Snooper Timer", true);
    private final Object syncLock = new Object();
    private final long minecraftStartTimeMilis;
    private boolean isRunning;
    private int selfCounter;

    public Snooper(String p_i1563_1_, ISnooperInfo p_i1563_2_, long p_i1563_3_) {
        try {
            this.serverUrl = new URL("http://snoop.minecraft.net/" + p_i1563_1_ + "?version=" + 2);
        }
        catch (MalformedURLException lvt_5_1_) {
            throw new IllegalArgumentException();
        }
        this.playerStatsCollector = p_i1563_2_;
        this.minecraftStartTimeMilis = p_i1563_3_;
    }

    public void startSnooper() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.addOSData();
        this.threadTrigger.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void run() {
                void lvt_1_2_;
                if (!Snooper.this.playerStatsCollector.isSnooperEnabled()) {
                    return;
                }
                Object object = Snooper.this.syncLock;
                synchronized (object) {
                    HashMap lvt_1_1_ = Maps.newHashMap((Map)Snooper.this.clientStats);
                    if (Snooper.this.selfCounter == 0) {
                        lvt_1_1_.putAll(Snooper.this.snooperStats);
                    }
                    lvt_1_1_.put("snooper_count", Snooper.this.selfCounter++);
                    lvt_1_1_.put("snooper_token", Snooper.this.uniqueID);
                }
                MinecraftServer lvt_2_1_ = Snooper.this.playerStatsCollector instanceof MinecraftServer ? (MinecraftServer)Snooper.this.playerStatsCollector : null;
                HttpUtil.postMap(Snooper.this.serverUrl, (Map<String, Object>)lvt_1_2_, true, lvt_2_1_ == null ? null : lvt_2_1_.getServerProxy());
            }
        }, 0L, 900000L);
    }

    private void addOSData() {
        this.addJvmArgsToSnooper();
        this.addClientStat("snooper_token", this.uniqueID);
        this.addStatToSnooper("snooper_token", this.uniqueID);
        this.addStatToSnooper("os_name", System.getProperty("os.name"));
        this.addStatToSnooper("os_version", System.getProperty("os.version"));
        this.addStatToSnooper("os_architecture", System.getProperty("os.arch"));
        this.addStatToSnooper("java_version", System.getProperty("java.version"));
        this.addClientStat("version", "1.11.2");
        this.playerStatsCollector.addServerTypeToSnooper(this);
    }

    private void addJvmArgsToSnooper() {
        RuntimeMXBean lvt_1_1_ = ManagementFactory.getRuntimeMXBean();
        List<String> lvt_2_1_ = lvt_1_1_.getInputArguments();
        int lvt_3_1_ = 0;
        for (String lvt_5_1_ : lvt_2_1_) {
            if (!lvt_5_1_.startsWith("-X")) continue;
            this.addClientStat("jvm_arg[" + lvt_3_1_++ + "]", lvt_5_1_);
        }
        this.addClientStat("jvm_args", lvt_3_1_);
    }

    public void addMemoryStatsToSnooper() {
        this.addStatToSnooper("memory_total", Runtime.getRuntime().totalMemory());
        this.addStatToSnooper("memory_max", Runtime.getRuntime().maxMemory());
        this.addStatToSnooper("memory_free", Runtime.getRuntime().freeMemory());
        this.addStatToSnooper("cpu_cores", Runtime.getRuntime().availableProcessors());
        this.playerStatsCollector.addServerStatsToSnooper(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientStat(String p_addClientStat_1_, Object p_addClientStat_2_) {
        Object object = this.syncLock;
        synchronized (object) {
            this.clientStats.put(p_addClientStat_1_, p_addClientStat_2_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatToSnooper(String p_addStatToSnooper_1_, Object p_addStatToSnooper_2_) {
        Object object = this.syncLock;
        synchronized (object) {
            this.snooperStats.put(p_addStatToSnooper_1_, p_addStatToSnooper_2_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public Map<String, String> getCurrentStats() {
        LinkedHashMap lvt_1_1_ = Maps.newLinkedHashMap();
        Object object = this.syncLock;
        synchronized (object) {
            this.addMemoryStatsToSnooper();
            for (Map.Entry<String, Object> lvt_4_1_ : this.snooperStats.entrySet()) {
                lvt_1_1_.put(lvt_4_1_.getKey(), lvt_4_1_.getValue().toString());
            }
            for (Map.Entry<String, Object> lvt_4_2_ : this.clientStats.entrySet()) {
                lvt_1_1_.put(lvt_4_2_.getKey(), lvt_4_2_.getValue().toString());
            }
        }
        return lvt_1_1_;
    }

    public boolean isSnooperRunning() {
        return this.isRunning;
    }

    public void stopSnooper() {
        this.threadTrigger.cancel();
    }

    @SideOnly(value=Side.CLIENT)
    public String getUniqueID() {
        return this.uniqueID;
    }

    public long getMinecraftStartTimeMillis() {
        return this.minecraftStartTimeMilis;
    }
}

